% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ipf_net.R
\name{ipf_net}
\alias{ipf_net}
\title{Iterative Proportional Fitting Routine for the Indirect Estimation of Origin-Destination-Type Migration Flow Tables with Known Net Migration Totals.}
\usage{
ipf_net(ntot = NULL, m = NULL, tol = 1e-05, maxit = 500,
  verbose = TRUE)
}
\arguments{
\item{ntot}{Vector of net migraiton totals to constrain the sum of the imputed cell columns. Elements must sum to zero.}

\item{m}{Array of auxiliary data. By default set to 1 for all origin-destination-migrant typologies combinations.}

\item{tol}{Numeric value for the tolerance level used in the parameter estimation.}

\item{maxit}{Numeric value for the maximum number of iterations used in the parameter estimation.}

\item{verbose}{Logical value to indicate the print the parameter estimates at each iteration. By default \code{FALSE}.}
}
\value{
Iterative Proportional Fitting routine set up using the partial likelihood derivatives. The argument \code{ntot} takes the known net migration totals.
The user must ensure that the net migraiton totals sum to globally to zero.

Returns a \code{list} object with
\item{mu }{Array of indirect estimates of origin-destination matrices by migrant characteristic}
\item{it }{Iteration count}
\item{tol }{Tolerance level at final iteration}
}
\description{
The \code{ipf_net} function finds the maximum likelihood estimates for fitted values in the log-linear model:
\deqn{ ??? }
}
\examples{
m <- matrix(data = 1:16, nrow = 4)
y <- ipf_net(ntot = c(30, 40, -15, -55), m = m)
addmargins(m)
net_sum(y$mu)
}
\author{
Guy J. Abel
}
