% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/member_community.R
\name{community}
\alias{community}
\alias{node_kernighanlin}
\title{Community graph partitioning algorithms}
\usage{
node_kernighanlin(object)
}
\arguments{
\item{object}{An object of a migraph-consistent class:
\itemize{
\item matrix (adjacency or incidence) from \code{{base}} R
\item edgelist, a data frame from \code{{base}} R or tibble from \code{{tibble}}
\item igraph, from the \code{{igraph}} package
\item network, from the \code{{network}} package
\item tbl_graph, from the \code{{tidygraph}} package
}}
}
\description{
Community graph partitioning algorithms
}
\section{Functions}{
\itemize{
\item \code{node_kernighanlin}: A greedy, iterative, deterministic graph
partitioning algorithm that results in a graph with two
equally-sized communities
}}

\examples{
node_kernighanlin(ison_adolescents)
node_kernighanlin(ison_southern_women)
}
\references{
Kernighan, Brian W., and Shen Lin. 1970.
"An efficient heuristic procedure for partitioning graphs."
\emph{The Bell System Technical Journal} 49(2): 291-307.
\doi{10.1002/j.1538-7305.1970.tb01770.x}
}
\seealso{
Other membership: 
\code{\link{components}()},
\code{\link{equivalence}}
}
\concept{membership}
