% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/to.R
\name{to}
\alias{to}
\alias{to_unweighted}
\alias{to_unnamed}
\alias{to_undirected}
\alias{to_onemode}
\alias{to_main_component}
\alias{to_uniplex}
\alias{to_unsigned}
\alias{to_simplex}
\alias{to_named}
\alias{to_multilevel}
\title{Tools for reformatting networks, graphs, and matrices}
\usage{
to_unweighted(object, threshold = 1)

to_unnamed(object)

to_undirected(object)

to_onemode(object)

to_main_component(object)

to_uniplex(object, edge)

to_unsigned(object, keep = c("positive", "negative"))

to_simplex(object)

to_named(object)

to_multilevel(object)
}
\arguments{
\item{object}{A matrix, \code{{igraph}} graph, \code{{tidygraph}} tbl_graph, or
\code{{network}} object.}

\item{threshold}{For a matrix, the threshold to binarise/dichotomise at.}

\item{edge}{the name of an edge attribute to retain from a graph}

\item{keep}{in the case of a signed network, whether to retain
the "positive" or "negative" ties}
}
\description{
Note that \code{to_onemode()}, which is currently only implemented for igraph,
is not the same as \code{project_rows()} and \code{project_cols()}.
There is no transformation involved; \code{to_onemode()} simply deletes the 'type'
attribute from vertices, removing the bipartite note, but retaining all
vertices.
}
\examples{
to_unweighted(project_rows(southern_women))
to_unnamed(project_rows(southern_women))
to_undirected(ison_coleman)
to_onemode(ison_marvel_teams)
to_uniplex(ison_m182, "friend_tie")
to_unsigned(ison_marvel_relationships, "positive")
to_unsigned(ison_marvel_relationships, "negative")
to_simplex(ison_m182)
to_named(ison_m182)
to_multilevel(mpn_elite_usa_advice)
}
