% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/measure_centrality.R
\name{degree_centrality}
\alias{degree_centrality}
\alias{node_degree}
\alias{node_outdegree}
\alias{node_indegree}
\alias{tie_degree}
\alias{network_degree}
\alias{network_outdegree}
\alias{network_indegree}
\title{Measures of degree-like centrality and centralisation}
\usage{
node_degree(
  .data,
  normalized = TRUE,
  alpha = 0,
  direction = c("all", "out", "in")
)

node_outdegree(.data, normalized = TRUE, alpha = 0)

node_indegree(.data, normalized = TRUE, alpha = 0)

tie_degree(.data, normalized = TRUE)

network_degree(.data, normalized = TRUE, direction = c("all", "out", "in"))

network_outdegree(.data, normalized = TRUE)

network_indegree(.data, normalized = TRUE)
}
\arguments{
\item{.data}{An object of a \code{{manynet}}-consistent class:
\itemize{
\item matrix (adjacency or incidence) from \code{{base}} R
\item edgelist, a data frame from \code{{base}} R or tibble from \code{{tibble}}
\item igraph, from the \code{{igraph}} package
\item network, from the \code{{network}} package
\item tbl_graph, from the \code{{tidygraph}} package
}}

\item{normalized}{Logical scalar, whether the centrality scores are normalized.
Different denominators are used depending on whether the object is one-mode or two-mode,
the type of centrality, and other arguments.}

\item{alpha}{Numeric scalar, the positive tuning parameter introduced in
Opsahl et al (2010) for trading off between degree and strength centrality measures.
By default, \code{alpha = 0}, which ignores tie weights and the measure is solely based
upon degree (the number of ties).
\code{alpha = 1} ignores the number of ties and provides the sum of the tie weights
as strength centrality.
Values between 0 and 1 reflect different trade-offs in the relative contributions of
degree and strength to the final outcome, with 0.5 as the middle ground.
Values above 1 penalise for the number of ties.
Of two nodes with the same sum of tie weights, the node with fewer ties will obtain
the higher score.
This argument is ignored except in the case of a weighted network.}

\item{direction}{Character string, “out” bases the measure on outgoing ties,
“in” on incoming ties, and "all" on either/the sum of the two.
For two-mode networks, "all" uses as numerator the sum of differences
between the maximum centrality score for the mode
against all other centrality scores in the network,
whereas "in" uses as numerator the sum of differences
between the maximum centrality score for the mode
against only the centrality scores of the other nodes in that mode.}
}
\value{
A single centralization score if the object was one-mode,
and two centralization scores if the object was two-mode.

Depending on how and what kind of an object is passed to the function,
the function will return a \code{tidygraph} object where the nodes have been updated
}
\description{
These functions calculate common centrality measures for one- and two-mode networks.
All measures attempt to use as much information as they are offered,
including whether the networks are directed, weighted, or multimodal.
If this would produce unintended results,
first transform the salient properties using e.g. \code{\link[=to_undirected]{to_undirected()}} functions.
All centrality and centralization measures return normalized measures by default,
including for two-mode networks.
}
\section{Functions}{
\itemize{
\item \code{node_degree()}: Calculates the degree centrality of nodes in an unweighted network,
or weighted degree/strength of nodes in a weighted network.

\item \code{node_outdegree()}: Wraps node_degree(..., direction = "out")

\item \code{node_indegree()}: Wraps node_degree(..., direction = "in")

\item \code{tie_degree()}: Calculate the degree centrality of edges in a network

\item \code{network_degree()}: Calculate the degree centralization for a graph

\item \code{network_outdegree()}: Wraps network_degree(..., direction = "out")

\item \code{network_indegree()}: Wraps network_degree(..., direction = "out")

}}
\examples{
node_degree(mpn_elite_mex)
node_degree(ison_southern_women)
tie_degree(ison_adolescents)
network_degree(ison_southern_women, direction = "in")
}
\references{
Faust, Katherine. 1997.
"Centrality in affiliation networks."
\emph{Social Networks} 19(2): 157-191.
\doi{10.1016/S0378-8733(96)00300-0}.

Borgatti, Stephen P., and Martin G. Everett. 1997.
"Network analysis of 2-mode data."
\emph{Social Networks} 19(3): 243-270.
\doi{10.1016/S0378-8733(96)00301-2}.

Borgatti, Stephen P., and Daniel S. Halgin. 2011.
"Analyzing affiliation networks."
In \emph{The SAGE Handbook of Social Network Analysis},
edited by John Scott and Peter J. Carrington, 417–33.
London, UK: Sage.
\doi{10.4135/9781446294413.n28}.

Opsahl, Tore, Filip Agneessens, and John Skvoretz. 2010.
"Node centrality in weighted networks: Generalizing degree and shortest paths."
\emph{Social Networks} 32, 245-251.
\doi{10.1016/j.socnet.2010.03.006}
}
\seealso{
\code{\link[=to_undirected]{to_undirected()}} for removing edge directions
and \code{\link[=to_unweighted]{to_unweighted()}} for removing weights from a graph.

Other measures: 
\code{\link{between_centrality}},
\code{\link{close_centrality}},
\code{\link{closure}},
\code{\link{cohesion}()},
\code{\link{eigenv_centrality}},
\code{\link{features}},
\code{\link{heterogeneity}},
\code{\link{holes}}

Other centrality: 
\code{\link{between_centrality}},
\code{\link{close_centrality}},
\code{\link{eigenv_centrality}}
}
\concept{centrality}
\concept{measures}
