% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checks.R
\name{check_group_partitions}
\alias{check_group_partitions}
\title{Check the validity of the group_partitions list}
\usage{
check_group_partitions(dataset, groups, group_partitions)
}
\arguments{
\item{dataset}{Data frame with an outcome variable and other columns as features.}

\item{groups}{Vector of groups to keep together when splitting the data into
train and test sets. If the number of groups in the training set is larger
than \code{kfold}, the groups will also be kept together for cross-validation.
Length matches the number of rows in the dataset (default: \code{NULL}).}

\item{group_partitions}{Specify how to assign \code{groups} to the training and
testing partitions (default: \code{NULL}). If \code{groups} specifies that some
samples belong to group \code{"A"} and some belong to group \code{"B"}, then setting
\code{group_partitions = list(train = c("A", "B"), test = c("B"))} will result
in all samples from group \code{"A"} being placed in the training set, some
samples from \code{"B"} also in the training set, and the remaining samples from
\code{"B"} in the testing set. The partition sizes will be as close to
\code{training_frac} as possible. If the number of groups in the training set is
larger than \code{kfold}, the groups will also be kept together for
cross-validation.}
}
\description{
Check the validity of the group_partitions list
}
\examples{
\dontrun{
check_group_partitions(
  otu_mini_bin,
  sample(LETTERS[1:8],
    size = nrow(otu_mini_bin),
    replace = TRUE
  ),
  list(train = c("A", "B"), test = c("C", "D"))
)
}
}
\author{
Kelly Sovacool, \email{sovacool@umich.edu}
}
\keyword{internal}
