% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/snp_category.r
\name{SNP.category}
\alias{SNP.category}
\title{SNP.category}
\usage{
SNP.category(bed, Z, threshold = 0.8)
}
\arguments{
\item{bed}{A bed matrix}

\item{Z}{A vector of length \code{nrow(bed)}}

\item{threshold}{Variance thresholds}
}
\description{
SNP.category
}
\details{
This function determines a SNP Category from a covariable \code{Z},
which can be for example an indicator variable for a population strata, 
or the first genomic principal component.
}
\examples{
# a random vector of categories
ca <- sample(c("A","B","C"), 1e6, TRUE, c(0.05, 0.9, 0.05))
# a vector of p-values, with different distribution depending on the strata
p <- runif(1e6)**ifelse(ca == "A", .8, ifelse(ca == "B", 1, 1.2))
qqplot.pvalues(p, ca)

}
\seealso{
\code{\link{qqplot.pvalues}}
}
