% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utility.R
\name{read_sequences_from_fastq}
\alias{read_sequences_from_fastq}
\title{\code{read_sequences_from_fastq}}
\usage{
read_sequences_from_fastq(
  fastq_file,
  force_to_upper = TRUE,
  skip_n_reads = 0,
  max_n_reads = -1,
  output_quality = TRUE,
  quality_offset = 33,
  bp = MulticoreParam()
)
}
\arguments{
\item{fastq_file}{location of the fastq file}

\item{force_to_upper}{whether to transform sequences
to upper case, default to TRUE}

\item{skip_n_reads}{number of reads to skip, default to 0}

\item{max_n_reads}{maximum number of reads to read, default to -1 (all)}

\item{output_quality}{whether to output the quality scores, default to TRUE}

\item{quality_offset}{the quality offset to use, default to 33}

\item{bp}{BiocParallel backend to use for parallelization}
}
\value{
will return a list of sequences, with qualities as attribute
}
\description{
\code{read_sequences_from_fastq} get the sequences
from a fastq file, it completely ignores the quality scores
}
