% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrapper.R
\name{mm2dir}
\alias{mm2dir}
\title{Generate hierarchical directories according to a FreeMind mind map}
\usage{
mm2dir(from = NA, dir_to = NA, dir_quiet = FALSE)
}
\arguments{
\item{from}{Character. The source text of the (R) Markdown syntax text, the R code, the FreeMind mind map code, or the path to the directory.}

\item{dir_to}{Character. The path of the output directory.}

\item{dir_quiet}{Logical. Whether to display the results of generated directories.}
}
\value{
Directory generated.
}
\description{
Generate hierarchical directories according to a FreeMind mind map
}
\examples{
input <- system.file("examples/mindr-mm.mm", package = "mindr")
input_txt <- readLines(input, encoding = "UTF-8")
output <- file.path(tempdir(), "mindr")
mm2dir(input_txt, output)
message("Input:  ", input, "\nOutput: ", output)
# file.show(input) # Open the input file system2('open', output) # Open the
# output dir in explorer.  unlink(output, recursive = TRUE) # remove the output
# file
}
