% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dispatcher.R
\name{dispatcher}
\alias{dispatcher}
\title{Dispatcher}
\usage{
dispatcher(
  host,
  url = NULL,
  n = NULL,
  ...,
  asyncdial = FALSE,
  token = FALSE,
  tls = NULL,
  pass = NULL,
  rs = NULL,
  monitor = NULL
)
}
\arguments{
\item{host}{the character host URL to dial (where tasks are sent from),
including the port to connect to (and optionally for websockets, a path),
e.g. 'tcp://hostname:5555' or 'ws://10.75.32.70:5555/path'.}

\item{url}{(optional) the character URL or vector of URLs dispatcher should
listen at, including the port to connect to (and optionally for websockets,
a path), e.g. 'tcp://hostname:5555' or 'ws://10.75.32.70:5555/path'.
Specify 'tls+tcp://' or 'wss://' to use secure TLS connections. Tasks are
sent to daemons dialled into these URLs. If not supplied, 'n' local
inter-process URLs will be assigned automatically.}

\item{n}{(optional) if specified, the integer number of daemons to listen for.
Otherwise 'n' will be inferred from the number of URLs supplied in 'url'.
Where a single URL is supplied and 'n' > 1, 'n' unique URLs will be
automatically assigned for daemons to dial into.}

\item{...}{(optional) additional arguments passed through to \code{\link{daemon}}.
These include 'autoexit', 'cleanup', 'maxtasks', 'idletime', 'walltime'
and 'timerstart'.}

\item{asyncdial}{[default FALSE] whether to perform dials asynchronously. The
default FALSE will error if a connection is not immediately possible
(e.g. \code{\link{daemons}} has yet to be called on the host, or the
specified port is not open etc.). Specifying TRUE continues retrying
(indefinitely) if not immediately successful, which is more resilient but
can mask potential connection issues.}

\item{token}{[default FALSE] if TRUE, appends a unique 24-character token
to each URL path the dispatcher listens at (not applicable for TCP URLs
which do not accept a path).}

\item{tls}{[default NULL] (required for secure TLS connections) \strong{either}
the character path to a file containing the PEM-encoded TLS certificate
and associated private key (may contain additional certificates leading
to a validation chain, with the TLS certificate first), \strong{or} a
length 2 character vector comprising [i] the TLS certificate (optionally
certificate chain) and [ii] the associated private key.}

\item{pass}{[default NULL] (required only if the private key supplied to 'tls'
is encrypted with a password) For security, should be provided through a
function that returns this value, rather than directly.}

\item{rs}{[default NULL] the initial value of .Random.seed. This is set
automatically using L'Ecuyer-CMRG RNG streams generated by the host
process and should not be independently supplied.}

\item{monitor}{(for package internal use only) do not set this parameter.}
}
\value{
Invisible NULL.
}
\description{
Dispatches tasks from a host to daemons for processing, using FIFO
    scheduling, queuing tasks as required. Daemon / dispatcher settings
    may be controlled by \code{\link{daemons}} and this function should not
    need to be invoked directly.
}
\details{
The network topology is such that a dispatcher acts as a gateway
    between the host and daemons, ensuring that tasks received from the host
    are dispatched on a FIFO basis for processing. Tasks are queued at the
    dispatcher to ensure tasks are only sent to daemons that can begin
    immediate execution of the task.
}
