% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mirai.R
\name{launch_server}
\alias{launch_server}
\title{Launch mirai Server}
\usage{
launch_server(url, ...)
}
\arguments{
\item{url}{the client URL for the server to dial into as a character string,
including the port to connect to and (optionally) a path for websocket
URLs e.g. tcp://192.168.0.2:5555' or 'ws://192.168.0.2:5555/path'.}

\item{...}{(optional) additional arguments passed to \code{\link{server}}.}
}
\value{
Invisibly, integer system exit code (zero upon success).
}
\description{
Utility function which calls \code{\link{server}} in a background
    \code{Rscript} process. May be used to re-launch local daemons that have
    timed out.
}
\details{
Consider specifying the argument 'asyncdial' [default FALSE] whether
    to perform dials asynchronously. The default FALSE will error if a
    connection is not immediately possible (e.g. \code{\link{daemons}} has
    yet to be called on the client, or the specified port is not open etc.).
    Specifying TRUE continues retrying (indefinitely) if not immediately
    successful, which is more resilient but can mask potential connection
    issues.
}
\examples{
if (interactive()) {
# Only run examples in interactive R sessions

launch_server("abstract://mirai", asyncdial = FALSE, idletime = 60000L)

}

}
