% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/probtrace.R
\name{probtrace}
\alias{probtrace}
\title{Function to calculate probability trace lines}
\usage{
probtrace(x, Theta)
}
\arguments{
\item{x}{an extracted internal mirt object containing item information (see \code{\link{extract.item}})}

\item{Theta}{a vector (unidimensional) or matrix (unidimensional/multidimensional) of
latent trait values}
}
\description{
Given an internal mirt object extracted from an estimated model
compute the probability trace lines for all categories.
}
\examples{

mod <- mirt(Science, 1)
extr.2 <- extract.item(mod, 2)
Theta <- matrix(seq(-4,4, by = .1))
traceline <- probtrace(extr.2, Theta)
head(data.frame(traceline, Theta=Theta))

}
\references{
Chalmers, R., P. (2012). mirt: A Multidimensional Item Response Theory
Package for the R Environment. \emph{Journal of Statistical Software, 48}(6), 1-29.
\doi{10.18637/jss.v048.i06}
}
\seealso{
\code{\link{extract.item}}
}
\author{
Phil Chalmers \email{rphilip.chalmers@gmail.com}
}
\keyword{tracelines}
