% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misclassGLM.R
\name{simulate_GLM_dataset}
\alias{simulate_GLM_dataset}
\title{Simulate a Data Set to Use With \code{misclassGLM}}
\usage{
simulate_GLM_dataset(n = 1000, const = 0, alpha = 1, beta = -2,
  beta2 = NULL, logit = FALSE)
}
\arguments{
\item{n}{number observations}

\item{const}{constant}

\item{alpha}{parameter for X}

\item{beta}{parameter for M(1)}

\item{beta2}{parameter for M2, if NULL, M is a binary covariate, otherwise a three-valued categorical}

\item{logit}{logical, if true logit regression, otherwise Gaussian regression}
}
\description{
simulates a data set with
- one continuous variable X drawn from a Gaussian distribution,
- a binary or trinary variable M with misclassification (M2)
- a dependent variable either with added Gaussian noise or drawn from a logit distribution
}
\details{
This can be used to demonstrate the abilities of \code{\link{misclassGLM}}. For an example
see \code{\link{misclassGLM}}.
}
\seealso{
\code{\link{misclassGLM}}
}

