% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/seqtest.cor.R
\name{seqtest.cor}
\alias{seqtest.cor}
\title{Sequential triangular test for the product-moment correlation coefficient}
\usage{
seqtest.cor(x, k, rho, delta, alternative = c("two.sided", "less", "greater"),
  alpha = 0.05, beta = 0.1, output = TRUE, plot = FALSE)
}
\arguments{
\item{x}{initial data, i.e., product-moment correlation coefficient in a sub-sample of k observations.}

\item{k}{number of observations in each sub-sample.}

\item{rho}{a number indicating the correlation under the null hypothesis, \eqn{\rho}0.}

\item{delta}{minimum difference to be detected, \eqn{\delta}.}

\item{alternative}{a character string specifying the alternative hypothesis,}

\item{alpha}{type-I-risk, \eqn{\alpha}.}

\item{beta}{type-II-risk, \eqn{\beta}.}

\item{output}{logical: if \code{TRUE}, output is shown.}

\item{plot}{logical: if \code{TRUE}, an initial plot is generated.}
}
\value{
Returns an object of class \code{seqtest}, to be used for later update steps. The object has
following entries:

\tabular{ll}{
  \code{call}      \tab function call \cr
  \code{type}      \tab type of the test (i.e., correlation coefficient) \cr
  \code{spec}      \tab specification of function arguments \cr
  \code{tri}       \tab specification of triangular \cr
  \code{dat}       \tab data \cr
  \code{res}       \tab list with results \cr
}
}
\description{
This function performs the sequential triangular test for the product-moment correlation coefficient
}
\details{
Null and alternative hypothesis is specified using arguments \code{rho} and \code{delta}.
Note that the argument k (i.e., number of observations in each sub-sample) has to be specified. At least k = 4 is needed.
The optimal value of k should be determined based on statistical simulation using \code{\link{sim.seqtest.cor}} function.

In order to specify a one-sided test, argument \code{alternative} has to be used (i.e., two-sided tests are conducted by default).
That is, \code{alternative = "less"} specifies the null hypothesis, H0: \eqn{\rho} >= \eqn{\rho}0 and
the alternative hypothesis, H1: \eqn{\rho} < \eqn{\rho}0; \code{alternative = "greater"} specifies the
null hypothesis, H0: \eqn{\rho} <= \eqn{\rho}0 and the alternative hypothesis, H1: \eqn{\rho} > \eqn{\rho}0.

The main characteristic of the sequential triangular test is that there is no fixed sample size given
in advance. That is, for the most recent sampling point, one has to decide whether
sampling has to be continued or either the null- or the alternative hypothesis can be
accepted given specified precision requirements (i.e. type-I-risk, type-II-risk and an effect size).
The sequence of data  pairs must we split into sub-samples of length k >= 4 each.
The (cumulative) test statistic \code{Z.m} on a Cartesian coordinate system produces a "sequential path" on a
continuation area as a triangle. As long as the statistic remains within that triangle,
additional data have to be sampled. If the path touches or exceeds the borderlines of the triangle,
sampling is completed. Depending on the particular borderline, the null-hypothesis is either
accepted or rejected.
}
\examples{
#--------------------------------------
# H0: rho = 0.3, H1: rho != 0.3
# alpha = 0.05, beta = 0.2, delta = 0.2

seq.obj <- seqtest.cor(0.46, k = 14, rho = 0.3, delta = 0.2,
                       alpha = 0.05, beta = 0.2, plot = TRUE)

seq.obj <- update(seq.obj, c(0.56, 0.76, 0.56, 0.52))

#--------------------------------------
# H0: rho <= 0.3, H1: rho > 0.3
# alpha = 0.05, beta = 0.2, delta = 0.2

seq.obj <- seqtest.cor(0.46, k = 14, rho = 0.3, delta = 0.2,
                       alternative = "greater",
                       alpha = 0.05, beta = 0.2, plot = TRUE)

seq.obj <- update(seq.obj, c(0.56, 0.76, 0.66))
}
\author{
Takuya Yanagida \email{takuya.yanagida@univie.ac.at},
}
\references{
Schneider, B., Rasch, D., Kubinger, K. D., & Yanagida, T. (2015).
A Sequential triangular test of a correlation coefficient's null-hypothesis: 0 \eqn{< \rho \le \rho}0.
\emph{Statistical Papers, 56}, 689-699.
}
\seealso{
\code{\link{update.seqtest}}, \code{\link{sim.seqtest.cor}}
}

