% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/duplicates.r
\name{duplicates}
\alias{duplicatei}
\alias{duplicates}
\title{Determine Duplicates}
\usage{
duplicates(x)

duplicatei(x, first = TRUE)
}
\arguments{
\item{x}{A vector or data.frame to search for duplicates.}

\item{first}{Logical, \code{TRUE} to return the index also for the first
occurrence of values. Otherwise, a \code{0} is the index for the first
occurrence.}
}
\value{
\code{duplicates} returns a logical vector as \link{duplicated}, but with
\code{TRUE} values also for the first occurrence of duplicated values.\cr
\code{duplicatei} returns the index of the first occurrence of each unique
value.
}
\description{
Determine duplicates. \code{duplicates} returns a logical vector,
\code{duplicatei} an integer vector.
}
\examples{
#

x <- c(7, 7, 7, 2, 3, 2)
data.frame(
  data = x,
  duplicated = duplicated(x),
  duplicates = duplicates(x),
  duplicatei = duplicatei(x),
  duplicatei0 = duplicatei(x, FALSE))

#
}
\author{
Sven E. Templer
}

