% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sort.data.frame.r
\name{sort}
\alias{sort}
\alias{sort.data.frame}
\title{Sort data.frame Objects}
\usage{
\method{sort}{data.frame}(x, decreasing = FALSE, by = NULL, bye = NULL,
  na.last = NA, ...)
}
\arguments{
\item{x}{A data.frame.}

\item{decreasing}{Logical, sort in decreasing order. See also \link[base]{sort}.}

\item{by}{Index (integer) or names of columns in \code{x} to sort by in that
order.
If both \code{by} and \code{bye} are missing, all columns are used to sort 
in their order.}

\item{bye}{Unquoted column name or \code{list()} or \code{.()} with unquoted
column names to sort \code{x} by. Not evaluated if \code{by} is supplied.}

\item{na.last}{\code{TRUE} to put missing values last, \code{FALSE} to put 
first or \code{NA} to remove.}

\item{...}{Ignored for the data.frame method.}
}
\description{
Sort a data.frame by any column(s).
}
\examples{
#

d <- data.frame(a=c(1,1,1,2,NA),b=c(2,1,3,1,1),c=5:1)
d
sort(d) # sort by every column (a, then b, then c)
sort(d, TRUE, by="c") # decreasing by column 'c'
sort(d, bye=.(a,c)) # increasing by columns 'a' and then 'c'

#
}
\author{
Sven E. Templer
}
