% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makeLRsims.R, R/makeRefgen.R
\name{makeLRsims}
\alias{makeLRsims}
\title{Make likelihoods ratio (LRs) simulations: a function for obtaining expected LRs under relatedness and unrelatedness kinship hypothesis.}
\usage{
makeLRsims(reference, missing, numsims, seed)

makeLRsims(reference, missing, numsims, seed)
}
\arguments{
\item{reference}{Reference pedigree. It could be an input from read_fam() function or a pedigree built with pedtools.}

\item{missing}{Missing person ID/label indicated in the pedigree.}

\item{numsims}{Number of simulations performed.}

\item{seed}{Select a seed for simulations. If it is defined, results will be reproducible. Suggested, seed = 123}
}
\value{
An object of class data.frame with LRs obtained for both hypothesis, Unrelated where POI is not MP or Related where POI is MP.

An object of class data.frame with LRs obtained for both hypothesis, Unrelated where POI is not MP or Related where POI is MP.
}
\description{
Make likelihoods ratio (LRs) simulations: a function for obtaining expected LRs under relatedness and unrelatedness kinship hypothesis.

Make likelihoods ratio (LRs) simulations: a function for obtaining expected LRs under relatedness and unrelatedness kinship hypothesis.
}
\examples{
library(forrel) 
x = linearPed(2)
x = setMarkers(x, locusAttributes = NorwegianFrequencies[1:5])
x = profileSim(x, N = 1, ids = 2)[[1]]
plot(x)
datasim = makeLRsims(x, missing = 5, 10, 123)
library(forrel) 
x = linearPed(2)
x = setMarkers(x, locusAttributes = NorwegianFrequencies[1:5])
x = profileSim(x, N = 1, ids = 2)[[1]]
plot(x)
datasim = makeLRsims(x, missing = 5, 10, 123)
}
