% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simLRprelim.R
\name{simLRprelim}
\alias{simLRprelim}
\title{Simulate likelihoods ratio (LRs) based on preliminary investigation data: a function for obtaining expected LRs under relatedness and unrelatedness kinship hypothesis.}
\usage{
simLRprelim(
  vartype,
  numsims = 1000,
  seed = 123,
  ErrorRate = 0.05,
  alphaBdate = c(1, 4, 60, 11, 6, 4, 4),
  numReg = 6
)
}
\arguments{
\item{vartype}{Indicates type of preliminary investigation variable. Options are: sex, region, age, birthDate and height.}

\item{numsims}{Number of simulations performed.}

\item{seed}{Seed for simulations.}

\item{ErrorRate}{Error rate for sex, region, age and Height LR calculations.}

\item{alphaBdate}{Vector containing alpha parameters for Dirichlet distribution.}

\item{numReg}{Number of regions present in the case.}
}
\value{
An object of class data.frame with LRs obtained for both hypothesis, Unrelated where POI/UHR is not MP or Related where POI/UHR is MP.
}
\description{
Simulate likelihoods ratio (LRs) based on preliminary investigation data: a function for obtaining expected LRs under relatedness and unrelatedness kinship hypothesis.
}
\examples{
library(mispitools) 
simLRprelim("sex")
}
