% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/test_random_imp.R
\name{test_random_imp}
\alias{test_random_imp}
\title{Testing the random replacement imputation algorithm}
\usage{
test_random_imp(X_hat, list)
}
\arguments{
\item{X_hat}{Simulated matrix with no missingness (this matrix will be used to obtain the error between the original and imputed values). (Simulated_matrix output from the \code{\link{simulate}} function)}

\item{list}{List of matrices with various missingness patterns (MCAR, MAR, MNAR and optionally, MAP). (The input is ideally the R object that was generated using the \code{\link{all_patterns}} function)}
}
\value{
\item{Comp_time}{Computation time of imputation using method (default output)}
\item{MCAR_RMSE}{Root-mean-square error (RMSE) between the indexed original values and the imputed values in an MCAR missingness pattern (default output)}
\item{MAR_RMSE}{Root-mean-square error (RMSE) between the indexed original values and the imputed values in an MAR missingness pattern (default output)}
\item{MNAR_RMSE}{Root-mean-square error (RMSE) between the indexed original values and the imputed values in an MNAR missingness pattern (default output)}
\item{MAP_RMSE}{Root-mean-square error (RMSE) between the indexed original values and the imputed values in an MAP missingness pattern (optional output)}
\item{MCAR_MAE}{Mean absolute error (MAE) between the indexed original values and the imputed values in an MCAR missingness pattern (default output)}
\item{MAR_MAE}{Mean absolute error (MAE) between the indexed original values and the imputed values in an MAR missingness pattern (default output)}
\item{MNAR_MAE}{Mean absolute error (MAE) between the indexed original values and the imputed values in an MNAR missingness pattern (default output)}
\item{MAP_MAE}{Mean absolute error (MAE) between the indexed original values and the imputed values in an MAP missingness pattern (optional output)}
\item{MCAR_KS}{Kolmogorov–Smirnov test statistic (KS) between the indexed original values and the imputed values in an MCAR missingness pattern (default output)}
\item{MAR_KS}{Kolmogorov–Smirnov test statistic (KS) between the indexed original values and the imputed values in an MAR missingness pattern (default output)}
\item{MNAR_KS}{Kolmogorov–Smirnov test statistic (KS) between the indexed original values and the imputed values in an MNAR missingness pattern (default output)}
\item{MAP_KS}{Kolmogorov–Smirnov test statistic (KS) between the indexed original values and the imputed values in an MAP missingness pattern (optional output)}
}
\description{
\code{\link{test_random_imp}} tests the imputation accuracy of the random replacement imputation algorithm on matrices with various missing data patterns
}
\details{
This function tests the imputation accuracy of the random replacement imputation algorithm by comparing the
original simulated matrix with no missingness and the imputed matrices generated by the algorithm using the matrices with
MCAR, MAR, MNAR and (optionally) MAP missingness patterns. The function calculates root-mean-square error (RMSE),
mean absolute error (MAE), Kolmogorov–Smirnov D test statistic (KS) between the imputed datapoints and the original
datapoints (that were subsequently set to missing). The function will also calculate the cumulative computation time for
imputing all datasets. The function will automatically detect whether there is a MAP matrix in the list and calculate
RMSE for all matrices provided in the list.
}
\examples{
clindata_miss_mini <- clindata_miss[1:80,1:4]
cleaned <- clean(clindata_miss_mini, missingness_coding = -9)
metadata <- get_data(cleaned)
simulated <- simulate(rownum = metadata$Rows, colnum = metadata$Columns,
cormat = metadata$Corr_matrix)
miss_list <- all_patterns(simulated$Simulated_matrix,
                    MD_pattern = metadata$MD_Pattern,
                    NA_fraction = metadata$Fraction_missingness,
                    min_PDM = 2)

test_random_imp(X_hat = simulated$Simulated_matrix, list = miss_list)

}
