% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/impute_EM.R
\name{impute_EM}
\alias{impute_EM}
\title{EM imputation}
\usage{
impute_EM(
  ds,
  stochastic = TRUE,
  maxits = 1000,
  criterion = 1e-04,
  verbose = FALSE
)
}
\arguments{
\item{ds}{A data frame or matrix with missing values.}

\item{stochastic}{Logical; see details.}

\item{maxits}{Maximum number of iterations for the EM, passed to
\code{\link[norm:em.norm]{norm::em.norm()}}.}

\item{criterion}{If maximum relative difference in parameter estimates is
below this threshold, the EM algorithm stops. Argument is directly passed
to \code{\link[norm:em.norm]{norm::em.norm()}}.}

\item{verbose}{Should messages be given for special cases (see details)?}
}
\value{
An object of the same class as \code{ds} with imputed missing values.

The number of EM iterations are added as an attribute (\code{iterations}).
}
\description{
Impute missing values in a data frame or a matrix using parameters estimated
via EM
}
\details{
At first parameters are estimated via \code{\link[norm:em.norm]{norm::em.norm()}}. Then these
parameters are used in regression like models to impute the missing values.
If \code{stochachstic = FALSE}, the expected values (given the observed values and
the estimated parameters via EM) are imputed for the missing values of an
object. If \code{stochastic = TRUE}, residuals from a multivariate normal
distribution are added to these expected values.

If all values in a row are \code{NA} or the required part of the covariance matrix
for the calculation of the expected values is not invertible, parts of the
estimated mean vector will be imputed. If \code{stochastic = TRUE}, residuals will
be added to these values. If \code{verbose = TRUE}, a message will be given for
these rows.
}
\examples{
ds_orig <- mvtnorm::rmvnorm(100, rep(0, 7))
ds_mis <- delete_MCAR(ds_orig, p = 0.2)
ds_imp <- impute_EM(ds_mis, stochastic = FALSE)
}
\seealso{
\itemize{
\item \code{\link[norm:em.norm]{norm::em.norm()}}, which estimates the parameters
\item \code{\link[=impute_expected_values]{impute_expected_values()}}, which calculates the imputation values
}
}
