% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate.R
\name{simulate}
\alias{simulate}
\title{Simulation of an SBM}
\usage{
simulate(nNodes, mixtureParam, connectParam, directed = FALSE,
  covariates = NULL, covarParam = NULL)
}
\arguments{
\item{nNodes}{The number of nodes}

\item{mixtureParam}{The mixture parameters}

\item{connectParam}{The connectivity matrix (inter/intra clusters probabilities. provided on a logit scale for a model with covariates)}

\item{directed}{Boolean variable to indicate whether the network is directed or not. Default to \code{FALSE}.}

\item{covariates}{A list with M entries (the M covariates). Each entry of the list must be an N x N matrix.}

\item{covarParam}{An optional vector of parameters associated with the covariates, with size M}
}
\value{
an object with class \code{SBM_sampler}
}
\description{
Generates a realization (blocks and adjacency matrix) of a Stochastic Block model
}
\examples{
## SBM parameters
directed <- FALSE
N <- 300 # number of nodes
Q <- 3   # number of clusters
M <- 2 # two Gaussian covariates
alpha <- rep(1, Q)/Q     # mixture parameters
pi <- diag(.45, Q) + .05 # connectivity matrix
eta <- rnorm(M, -1, 1)  # covariate parametes
gamma <- log(pi/(1-pi)) # logit transform of pi for the model with covariates
X <- replicate(M, matrix(rnorm(N * N ,mean = 0, sd = 1), N, N), simplify = FALSE)

## draw a SBM without covariates
sbm <- missSBM::simulate(N, alpha, pi, directed)

## draw a SBM model with node-centred covariates
sbm_cov <- missSBM::simulate(N, alpha, gamma, directed, X, eta)

old_param <- par(mfrow = c(1,2))
plot(sbm)
plot(sbm_cov)
par(old_param)

}
\seealso{
The class \code{\link{SBM_sampler}}
}
