% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/R6Class-partlyObservedNetwork.R
\name{partlyObservedNetwork}
\alias{partlyObservedNetwork}
\title{An R6 Class used for internal representation of a partially observed network}
\description{
An R6 Class used for internal representation of a partially observed network

An R6 Class used for internal representation of a partially observed network
}
\details{
This class is not exported to the user
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{samplingRate}}{The percentage of observed dyads}

\item{\code{nbNodes}}{The number of nodes}

\item{\code{nbDyads}}{The number of dyads}

\item{\code{is_directed}}{logical indicating if the network is directed or not}

\item{\code{netMatrix}}{The adjacency matrix of the network}

\item{\code{covarArray}}{the array of covariates}

\item{\code{covarMatrix}}{the matrix of covariates}

\item{\code{dyads}}{a list of potential dyads in the network}

\item{\code{missingDyads}}{array indices of missing dyads}

\item{\code{observedDyads}}{array indices of observed dyads}

\item{\code{samplingMatrix}}{matrix of observed and non-observed edges}

\item{\code{observedNodes}}{a vector of observed and non-observed nodes}

\item{\code{NAs}}{boolean for NA entries in the adjacencyMatrix}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{partlyObservedNetwork$new()}}
\item \href{#method-clustering}{\code{partlyObservedNetwork$clustering()}}
\item \href{#method-imputation}{\code{partlyObservedNetwork$imputation()}}
\item \href{#method-clone}{\code{partlyObservedNetwork$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
constructor
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{partlyObservedNetwork$new(
  adjacencyMatrix,
  covariates = NULL,
  similarity = missSBM:::l1_similarity
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{adjacencyMatrix}}{The adjacency matrix of the network}

\item{\code{covariates}}{A list with M entries (the M covariates), each of whom being either a size-N vector or N x N matrix.}

\item{\code{similarity}}{An R x R -> R function to compute similarities between node covariates. Default is \code{l1_similarity}, that is, -abs(x-y).}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clustering"></a>}}
\if{latex}{\out{\hypertarget{method-clustering}{}}}
\subsection{Method \code{clustering()}}{
method to cluster network data with missing value
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{partlyObservedNetwork$clustering(
  nbBlocks,
  method = c("hierarchical", "spectral", "kmeans")
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{nbBlocks}}{integer, the chosen number of blocks}

\item{\code{method}}{character with a clustering method among "hierarchical", "spectral", "kmeans".}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-imputation"></a>}}
\if{latex}{\out{\hypertarget{method-imputation}{}}}
\subsection{Method \code{imputation()}}{
basic imputation from existing clustering
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{partlyObservedNetwork$imputation(clustering)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{clustering}}{a vector with size \code{ncol(adjacencyMatrix)}, providing a user-defined clustering with \code{nbBlocks} levels.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
an adjacency matrix with imputed values
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{partlyObservedNetwork$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
