% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run_pattern.R
\name{run_pattern}
\alias{run_pattern}
\title{An internal function to execute a JAGS pattern mixture model and get posterior results}
\usage{
run_pattern(type, dist_e, dist_c, inits, d_list, d1, d2)
}
\arguments{
\item{type}{Type of missingness mechanism assumed. Choices are Missing At Random (MAR), Missing Not At Random for the effects (MNAR_eff),
Missing Not At Random for the costs (MNAR_cost), and Missing Not At Random for both (MNAR)}

\item{dist_e}{distribution assumed for the effects. Current available choices are: Normal ('norm') or Beta ('beta').}

\item{dist_c}{Distribution assumed for the costs. Current available choices are: Normal ('norm'), Gamma ('gamma') or LogNormal ('lnorm')}

\item{inits}{a list with elements equal to the number of chains selected; each element of the list is itself a list of starting values for the BUGS model, 
or a function creating (possibly random) initial values. If inits is NULL, JAGS will generate initial values for parameters}

\item{d_list}{a list of the number and types of patterns in the data}

\item{d1}{Patterns in the control}

\item{d2}{Patterns in the intervention}
}
\description{
This function fits a JAGS using the \code{\link[R2jags]{jags}} function and obtain posterior inferences.
}
\examples{
# Internal function only
# No examples
#
#
}
\keyword{Bayesian}
\keyword{JAGS}
\keyword{mixture}
\keyword{models}
\keyword{pattern}
