% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{jumps}
\alias{jumps}
\alias{jumps.discrdist}
\alias{jumps.trans_discrdist}
\alias{jumps.contdist}
\alias{jumps.trans_contdist}
\alias{jumps.mixdist}
\alias{jumps.trans_mixdist}
\alias{jumps.compdist}
\alias{jumps.trans_compdist}
\title{Probability mass points}
\usage{
jumps(O, interval)

\method{jumps}{discrdist}(O, interval)

\method{jumps}{trans_discrdist}(O, interval)

\method{jumps}{contdist}(O, interval)

\method{jumps}{trans_contdist}(O, interval)

\method{jumps}{mixdist}(O, interval)

\method{jumps}{trans_mixdist}(O, interval)

\method{jumps}{compdist}(O, interval)

\method{jumps}{trans_compdist}(O, interval)
}
\arguments{
\item{O}{distribution object.}

\item{interval}{interval in which the support of discrete elements should be found.}
}
\value{
Vector of values.
}
\description{
Function returns a vector of points where a mass of probability is present.
             These points are then used in \code{\link{plot}} and \code{\link{plotgg}} calls.
}
\note{
The function is designed in a way that it rather returns more than less. Thus it might
     return a value that is close to the interval but not in. This is for use of the package not a problem as
     jumps is internally used only in plots and quantile function of a mixture distribution where an
     additional value can not influence the output.
}
\examples{
B <- binomdist(12, 0.4)
P <- poisdist(2)

I <- c(-7, 16.8)
jumps(B, I)
jumps(P, I)
}
