% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/creators.R
\name{nbinomdist}
\alias{nbinomdist}
\title{Creates an Object Representing Negative Binomial Distribution}
\usage{
nbinomdist(size = 10, prob, mu)
}
\arguments{
\item{size}{size parameter, default: 10.}

\item{prob}{probability parameter.}

\item{mu}{alternative parametrization via mean, see \code{\link[stats]{NegBinomial}}.}
}
\value{
Object of class nbinomdist.
}
\description{
The function creates an object which represents the negative binomial distribution.
}
\details{
See \code{\link[stats]{NegBinomial}}.
}
\examples{
N <- nbinomdist(10, 0.5)
d(N, c(2, 3, 4, NA))
r(N, 5)
}
\seealso{
\code{\link[stats]{NegBinomial}}
}
