% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compdist.R, R/standist.R, R/trans_standist.R
\name{qlim.compdist}
\alias{qlim.compdist}
\alias{qlim}
\alias{qlim.discrdist}
\alias{qlim.contdist}
\alias{qlim.trans_univdist}
\title{Right-Hand Limit of Quantile Function}
\usage{
\method{qlim}{compdist}(O, p, lower.tail = TRUE, log.p = FALSE)

qlim(O, p, lower.tail = TRUE, log.p = FALSE)

\method{qlim}{discrdist}(O, p, lower.tail = TRUE, log.p = FALSE)

\method{qlim}{contdist}(O, p, lower.tail = TRUE, log.p = FALSE)

\method{qlim}{trans_univdist}(O, p, lower.tail = TRUE, log.p = FALSE)
}
\arguments{
\item{O}{distribution object.}

\item{p}{vector of probabilities.}

\item{lower.tail}{logical; if TRUE, probabilities are \eqn{P[X \le x]} otherwise, \eqn{P[X > x]}, default: TRUE.}

\item{log.p}{logical; if TRUE, probabilities \eqn{p} are given as \eqn{log(p)}, default: FALSE.}
}
\value{
Vector of computed results.
}
\description{
\code{qlim} is a generic function that evaluates the right-hand limit of quantile function
             for a distribution object at given values.
}
\details{
Methods of \code{qlim} function evaluates the right-hand limit of any offered
         distribution object from the package \code{\link{mistr}}. The right-hand limit
         of a quantile function is defined as
         \deqn{Q(x+)=inf{x: p<P(X\le x)}.}
         The function makes use of the p[sufix] and q[sufix] functions
         as \code{pnorm}, \code{pbeta}, \code{qnorm}, \code{qbeta}, and thus, if a new distribution is added,
         these functions must be reachable through the search path.

         Methods for \code{\link[=qlim.discrmixdist]{mixtures}} have its own help page.
}
\examples{
B <- binomdist(10, 0.3)
qlim(B, plim(B, c(NA, 1, 3, 5)))

P <- poisdist()
M <- mixdist(B, P, weights = c(0.5, 0.5))
qlim(M, plim(M, c(NA, 1, 3, 5)))

CC <- compdist(B, P, weights = c(0.5, 0.5), breakpoints = 1)
CCC <- 2*CC+5
qlim(CCC, plim(CCC, c(NA, 1, 3, 5)))
}
