% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.phi.coef.R
\name{print.phi.coef}
\alias{print.phi.coef}
\title{Print phi.coef object}
\usage{
\method{print}{phi.coef}(x, tri = x$args$tri, digits = x$args$digits,
      check = TRUE, ...)
}
\arguments{
\item{x}{\code{phi.coef} object.}

\item{tri}{a character string or character vector indicating which triangular of the matrix
to show on the console, i.e., \code{both} for upper and lower triangular,
\code{lower} for the lower triangular, and \code{upper} for the upper
triangular.}

\item{digits}{an integer value indicating the number of decimal places digits to be used for
displaying contingency coefficients.}

\item{check}{logical: if \code{TRUE}, argument specification is checked.}

\item{...}{further arguments passed to or from other methods.}
}
\description{
This function prints the \code{phi.coef} object
}
\examples{
dat <- data.frame(x1 = c(0, 1, 0, 1, 0, 1, 0, 1, 1, 0),
                  x2 = c(0, 1, 0, 0, 1, 1, 1, 1, 1, 1),
                  x3 = c(0, 1, 0, 1, 1, 1, 1, 1, 0, 0))

# Ajusted phi coefficient between x1 and x2
dat.phi <- phi.coef(dat[, c("x1", "x2")], output = FALSE)

# Print phi.coef object with 5 digits
print(dat.phi, digits = 5)
}
\seealso{
\code{\link{phi.coef}}
}
\author{
Takuya Yanagida \email{takuya.yanagida@univie.ac.at}
}
