% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mplus.R
\name{mplus}
\alias{mplus}
\title{Create, Run, and Print Mplus Models}
\usage{
mplus(x, file = "Mplus_Input.inp", replace.inp = TRUE, data = NULL, mplus.run = TRUE,
      show.out = FALSE, replace.out = c("always", "never", "modified"),
      print = c("all", "input", "result"),
      input = c("all", "default", "data", "variable", "define", "analysis",
                "model", "montecarlo", "mod.pop", "mod.cov", "mod.miss",
                "message"),
      result = c("all", "default", "summary.analysis.short",
                 "summary.data.short", "random.starts", "summary.fit",
                 "mod.est", "fit", "class.count", "classif", "mod.result",
                 "total.indirect"),
      exclude = NULL, variable = FALSE, not.input = TRUE, not.result = TRUE,
      write = NULL, append = TRUE, check = TRUE, output = TRUE)
}
\arguments{
\item{x}{a character string containing the Mplus input text.}

\item{file}{a character string indicating the name of the Mplus input
file with or without the file extension \code{.inp}, e.g.,
\code{"Mplus_Input.inp"} or \code{"Mplus_Input"}.}

\item{replace.inp}{logical: if \code{TRUE} (default), an existing input
file will be replaced.}

\item{data}{a matrix or data frame from which the variables names for
the subsection \code{NAMES} are extracted when using the
\code{...} specification in the \code{VARIABLE} section.}

\item{mplus.run}{logical: if \code{TRUE}, the input file specified in the
argument \code{file} containing the input text specified
in the argument \code{x} is run using the \code{mplus.run()}
function.}

\item{show.out}{logical: if \code{TRUE}, estimation output (\code{TECH8})
is show on the R console. Note that if run within Rgui,
output will display within R, but if run via Rterm, a
separate window will appear during estimation.}

\item{replace.out}{a character string for specifying three settings:
\code{"always"} (default), which runs all models, regardless
of whether an output file for the model exists, \code{"never"},
which does not run any model that has an existing output file,
and \code{"modified"}, which only runs a model if the
modified date for the input file is more recent than the
output file modified date.}

\item{print}{a character vector indicating which results to show, i.e.
\code{"all"} (default) for all results \code{"input"} for
input command sections, and \code{"result"} for result sections.}

\item{input}{a character vector specifiying Mplus input command sections
included in the output (see 'Details' in the \code{\link{mplus.print}}
function).}

\item{result}{a character vector specifiying Mplus result sections included
in the output (see 'Details' in the \code{\link{mplus.print}}
function).}

\item{exclude}{a character vector specifiying Mplus input command or result
sections excluded from the output (see 'Details' in the
\code{\link{mplus.print}} function).}

\item{variable}{logical: if \code{TRUE}, names of the variables in the data
set (\code{NAMES ARE}) specified in the \code{VARIABLE:}
command section are shown. By default, names of the variables
in the data set are excluded from the output unless all variables
are used in the analysis (i.e., no \code{USEVARIABLES} option
specified in the Mplus input file).}

\item{not.input}{logical: if \code{TRUE} (default), character vector indicating
the input commands not requested are shown on the console.}

\item{not.result}{logical: if \code{TRUE} (default), character vector indicating
the result sections not requested are shown on the console.}

\item{write}{a character string naming a file for writing the output into
a text file with file extension \code{".txt"} (e.g.,
\code{"Output.txt"}).}

\item{append}{logical: if \code{TRUE} (default), output will be appended
to an existing text file with extension \code{.txt} specified
in \code{write}, if \code{FALSE} existing text file will be
overwritten.}

\item{check}{logical: if \code{TRUE} (default), argument specification is
checked.}

\item{output}{logical: if \code{TRUE} (default), output is shown on the
console by using the function \code{mplus.print()}.}
}
\value{
Returns an object of class \code{misty.object}, which is a list with following
entries:

\item{\code{call}}{function call}
\item{\code{type}}{type of analysis}
\item{\code{x}}{a character vector containing the Mplus input text}
\item{\code{args}}{specification of function arguments}
\item{\code{input}}{list with input command sections}
\item{\code{write}}{write command sections}
\item{\code{result}}{list with input command sections (\code{input}) and
                     result sections (\code{input})}
}
\description{
This wrapper function creates a Mplus input file, runs the input file by using
the \code{mplus.run()} function, and prints the Mplus output file by using the
\code{mplus.print()} function.
}
\details{
\describe{
\item{\strong{The \code{NAMES} Option}}{in the \code{VARIABLE} section used to
assign names to the variables in the data set can be specified by using \code{...}
and the \code{data} argument:
   \itemize{
      \item{\code{Write Mplus Data File}}: In the first step, the Mplus data
      file is written by using the \code{write.mplus()} function, e.g.
      \code{write.mplus(ex3_1, file = "ex3_1.dat")}.
      \item{\code{Specify Mplus Input}}: In the second step, the Mplus input
      is specified as a character string. The \code{NAMES} option can be
      specified by using \code{...}, e.g.,
      \code{input <- 'DATA:     FILE IS ex3_1.dat;\nVARIABLE: ...\nMODEL:    y1 ON x1 x3;'}.
      \item{\code{Run Mplus Input}}: In the third step, the Mplus input is run
      by using the \code{mplus()} function. Note that the argument \code{data}
      needs to be specified given that the \code{NAMES} option was specified
      by using \code{...} in the previous step, e.g.,
      \code{mplus(input, file = "ex3_1.inp", data = ex3_1)}
   }
}
}
}
\examples{
\dontrun{
#----------------------------------------------------------------------------
# Example 1: Write data, specify input, and run input

# Write Mplus Data File
write.mplus(ex3_1, file = "ex3_1.dat")

# Specify Mplus input, specify NAMES option
input1 <- '
DATA:     FILE IS ex3_1.dat;
VARIABLE: NAMES ARE y1 x1 x3;
MODEL:    y1 ON x1 x3;
OUTPUT:   SAMPSTAT;
'

# Run Mplus input
mplus(input1, file = "ex3_1.inp")

#----------------------------------------------------------------------------
# Example 2: Alterantive specification using ... and the data argument

# Specify Mplus input, specify NAMES option by using ...
input2 <- '
DATA:     FILE IS ex3_1.dat;
VARIABLE: ...
MODEL:    y1 ON x1 x3;
OUTPUT:   SAMPSTAT;
'

# Run Mplus input
mplus(input2, file = "ex3_1.inp", data = ex3_1)
}
}
\references{
Muthen, L. K., & Muthen, B. O. (1998-2017). \emph{Mplus User's Guide} (8th ed.).
Muthen & Muthen.
}
\seealso{
\code{\link{read.mplus}}, \code{\link{write.mplus}}, \code{\link{mplus.print}},
\code{\link{mplus.update}}, \code{\link{mplus.run}},
\code{\link{mplus.lca}}
}
\author{
Takuya Yanagida
}
