% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/freq.R
\name{freq}
\alias{freq}
\title{Frequency Table}
\usage{
freq(data, ..., print = c("no", "all", "perc", "v.perc"), freq = TRUE,
     split = FALSE, labels = TRUE, val.col = FALSE, round = 3, exclude = 15,
     digits = 2, as.na = NULL, write = NULL, append = TRUE, check = TRUE,
     output = TRUE)
}
\arguments{
\item{data}{a vector, factor, or data frame.}

\item{...}{an expression indicating the variable names in \code{data},
e.g., \code{freq(dat, x1, x2, x3)}. Note that the operators
\code{+}, \code{-}, \code{~}, \code{:}, \code{::},
and \code{!} can also be used to select variables, see 'Details'
in the \code{\link{df.subset}} function.}

\item{print}{a character string indicating which percentage(s) to be
printed on the console, i.e., no percentages (\code{"no"}),
all percentages (\code{"all"}), percentage frequencies
(\code{"print"}), and valid percentage frequencies
(\code{"v.perc"}). Default setting when specifying one
variable is \code{print = "all"}, while default
setting when specifying more than one variable is \code{print = "no"}
unless \code{split = TRUE}.}

\item{freq}{logical: if \code{TRUE} (default), absolute frequencies will
be shown on the console.}

\item{split}{logical: if \code{TRUE}, output table is split by variables
when specifying more than one variable in \code{...}.}

\item{labels}{logical: if \code{TRUE} (default), labels for the factor
levels will be used.}

\item{val.col}{logical: if \code{TRUE}, values are shown in the columns,
variables in the rows.}

\item{round}{an integer value indicating the number of decimal places
to be used for rounding numeric variables.}

\item{exclude}{an integer value indicating the maximum number of unique
values for variables to be included in the analysis when
specifying more than one variable i.e.,
variables with the number of unique values exceeding
\code{exclude} will be excluded from the analysis. It is
also possible to specify \code{exclude = FALSE} to include
all variables in the analysis.}

\item{digits}{an integer value indicating the number of decimal places
to be used for displaying percentages.}

\item{as.na}{a numeric vector indicating user-defined missing values,
i.e. these values are converted to \code{NA} before
conducting the analysis.}

\item{write}{a character string naming a file for writing the output into
either a text file with file extension \code{".txt"} (e.g.,
\code{"Output.txt"}) or Excel file with file extension
\code{".xlsx"}  (e.g., \code{"Output.xlsx"}). If the file
name does not contain any file extension, an Excel file will
be written.}

\item{append}{logical: if \code{TRUE} (default), output will be appended
to an existing text file with extension \code{.txt} specified
in \code{write}, if \code{FALSE} existing text file will be
overwritten.}

\item{check}{logical: if \code{TRUE} (default), argument specification is checked.}

\item{output}{logical: if \code{TRUE} (default), output is shown on the console.}
}
\value{
Returns an object of class \code{misty.object}, which is a list with following
entries:
  \item{\code{call}}{function call}
  \item{\code{type}}{type of analysis}
  \item{\code{data}}{data frame used for the current analysis}
  \item{\code{args}}{specification of function arguments}
  \item{\code{result}}{list with result tables, i.e., \code{freq} for absolute
                       frequencies, \code{perc} for percentages, and \code{v.perc}
                       for valid percentages}
}
\description{
This function computes a frequency table with absolute and percentage frequencies
for one or more than one variable.
}
\details{
By default, the function displays the absolute and percentage frequencies when
specifying one variable, while the function displays only the absolute frequencies
when more than one variable is specified. The function displays valid percentage
frequencies only in the presence of missing values and excludes variables with
all values missing from the analysis. Note that it is possible to mix numeric
variables, factors, and character variables in the data frame specified in the
argument \code{data}. By default, numeric variables are rounded to three digits
before computing the frequency table.
}
\examples{
# Example 1: Frequency table for 'cyl'
freq(mtcars, cyl)

# Alternative specification without using the '...' argument
freq(mtcars$cyl)

# Example 2: Frequency table, values shown in columns
freq(mtcars, cyl, val.col = TRUE)

# Example 3: Frequency table, use 3 digit for displaying percentages
freq(mtcars, cyl, digits = 3)

# Example 4: Frequency table for 'cyl', 'gear', and 'carb'
freq(mtcars, cyl, gear, carb)

# Alternative specification without using the '...' argument
freq(mtcars[, c("cyl", "gear", "carb")])

# Example 5: Frequency table, with percentage frequencies
freq(mtcars, cyl, gear, carb, print = "all")

# Example 6: Frequency table, split output table
freq(mtcars, cyl, gear, carb, split = TRUE)

# Example 7: Frequency table, exclude variables with more than 5 unique values
freq(mtcars, exclude = 5)

\dontrun{
# Example 8a: Write Results into a text file
freq(mtcars, cyl, gear, carb, split = TRUE, write = "Frequencies.txt")

# Example 8b: Write Results into a Excel file
freq(mtcars, cyl, gear, carb, split = TRUE, write = "Frequencies.xlsx")
}
}
\references{
Becker, R. A., Chambers, J. M., & Wilks, A. R. (1988). \emph{The New  S Language}.
Wadsworth & Brooks/Cole.
}
\seealso{
\code{\link{write.result}}, \code{\link{crosstab}}, \code{\link{descript}},
\code{\link{multilevel.descript}}, \code{\link{na.descript}}.
}
\author{
Takuya Yanagida \email{takuya.yanagida@univie.ac.at}
}
