% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as.na.R
\name{na.as}
\alias{na.as}
\alias{as.na}
\title{Replace Missing Values With User-Specified Values or User-Specified Values With Missing Values}
\usage{
na.as(data, ..., na, replace = TRUE, as.na = NULL, check = TRUE)

as.na(data, ..., na, replace = TRUE, check = TRUE)
}
\arguments{
\item{data}{a vector, factor, matrix, array, data frame, or list.}

\item{...}{an expression indicating the variable names in \code{data}, e.g.,
\code{as.na(dat, x1, x2)} for selecting the variables \code{x1}
and \code{x2} from the data frame \code{dat}. Note that the
operators \code{+}, \code{-}, \code{~}, \code{:},
\code{::}, and \code{!} can also be used to select variables,
see 'Details' in the \code{\link{df.subset}} function.}

\item{na}{a vector indicating values or characters to replace with
\code{NA}, or which \code{NA} is replaced. Note that a numeric
value or character string needs to be specified for the argument
\code{na} when using \code{na.as}.}

\item{replace}{logical: if \code{TRUE} (default), variable(s) specified in
\code{...} are replaced in the argument \code{data}.}

\item{check}{logical: if \code{TRUE} (default), argument specification is
checked.}

\item{as.na}{a numeric vector or character vector indicating user-defined
missing values, i.e. these values are converted to \code{NA}
before conducting the analysis.}
}
\value{
Returns a vector, factor, matrix, array, data frame, or list specified in the
argument \code{data}.
}
\description{
The function \code{na.as} replaces \code{NA} in a vector, factor, list, matrix or
data frame with a user-specified value or character string in the argument \code{na},
while  the function \code{as.na} replaces user-specified values in the argument
\code{na} in a vector, factor, matrix, array, list, or data frame with \code{NA}.
}
\examples{
#----------------------------------------------------------------------------
# Numeric vector
num <- c(1, 3, 2, 4, 5)

# Example 11: Replace NA with 2
na.as(c(1, 3, NA, 4, 5), na = 2)

# Example 1b: Replace 2 with NA
as.na(num, na = 2)

# Example 1c: Replace 2, 3, and 4 with NA
as.na(num, na = c(2, 3, 4))

#----------------------------------------------------------------------------
# Character vector
chr <- c("a", "b", "c", "d", "e")

# Example 2a: Replace NA with "b"
na.as(c("a", NA, "c", "d", "e"), na = "b")

# Example 2b: Replace "b" with NA
as.na(chr, na = "b")

# Example 2c: Replace "b", "c", and "d" with NA
as.na(chr, na = c("b", "c", "d"))

#----------------------------------------------------------------------------
# Factor
fac <- factor(c("a", "a", "b", "b", "c", "c"))

# Example 3a: Replace NA with "b"
na.as(factor(c("a", "a", NA, NA, "c", "c")), na = "b")

# Example 3b: Replace "b" with NA
as.na(fac, na = "b")

# Example 3c: Replace "b" and "c" with NA
as.na(fac, na = c("b", "c"))

#----------------------------------------------------------------------------
# Matrix
mat <- matrix(1:20, ncol = 4)

# Example 4a: Replace NA with 2
na.as(matrix(c(1, NA, 3, 4, 5, 6), ncol = 2), na = 2)

# Example 4b: Replace 8 with NA
as.na(mat, na = 8)

# Example 4c: Replace 8, 14, and 20 with NA
as.na(mat, na = c(8, 14, 20))

#----------------------------------------------------------------------------
# Array

# Example 5: Replace 1 and 10 with NA
as.na(array(1:20, dim = c(2, 3, 2)), na = c(1, 10))

#----------------------------------------------------------------------------
# List

# Example 6:  Replace 1 with NA
as.na(list(x1 = c(1, 2, 3, 1, 2, 3), x2 = c(2, 1, 3, 2, 1)), na = 1)

#----------------------------------------------------------------------------
# Data frame
df <- data.frame(x1 = c(1, NA, 3), x2 = c(2, 1, 3), x3 = c(3, NA, 2))

# Example 7a: Replace NA with -99
na.as(df, na = -99)

# Example 7b: Replace 1 with NA
as.na(df, na = 1)

# Example 7c: Replace 1 with NA for the variable 'x2'
as.na(df, x2, na = 1)

# Alternative specification
as.na(df$x2, na = 1)

# Example 7d: Replace 1 and 3 with NA
as.na(df, na = c(1, 3))

# Example 7e: Replace 1 with NA in 'x2' and 'x3'
as.na(df, x2, x3, na = 1)
}
\references{
Becker, R. A., Chambers, J. M. and Wilks, A. R. (1988) \emph{The New S Language}.
Wadsworth & Brooks/Cole.
}
\seealso{
\code{\link{na.auxiliary}}, \code{\link{na.coverage}}, \code{\link{na.descript}},
\code{\link{na.indicator}}, \code{\link{na.pattern}}, \code{\link{na.prop}},
\code{\link{na.test}}
}
\author{
Takuya Yanagida \email{takuya.yanagida@univie.ac.at}
}
