\name{NMixRelabel}
\alias{NMixRelabel}
\alias{NMixRelabel.default}
\alias{NMixRelabel.NMixMCMC}
\alias{NMixRelabel.GLMM_MCMC}
\title{
  Re-labeling the MCMC output of the mixture model
}
\description{
  This function takes an object generated by the \code{\link{NMixMCMC}}
  or \code{\link{GLMM_MCMC}} function and internally re-labels the mixture
  components using selected re-labeling algorithm. It also computes
  posterior summary statistics for mixture means, weights, variances
  which correspond to newly labeled MCMC sample. Further, posterior
  component probabilities (\code{poster.comp.prob1} and
  \code{poster.comp.prob2} components of the object \code{object}) are
  updated according to the newly labeled MCMC sample.

  This function only works for models with a fixed number of mixture components.
}
\usage{
NMixRelabel(object, type=c("mean", "weight", "stephens"), par, \dots)

\method{NMixRelabel}{default}(object, type = c("mean", "weight", "stephens"), par, \dots)

\method{NMixRelabel}{NMixMCMC}(object, type = c("mean", "weight","stephens"), par,
   prob=c(0.025, 0.5, 0.975), keep.comp.prob = FALSE, info, \dots)

\method{NMixRelabel}{GLMM_MCMC}(object, type = c("mean", "weight", "stephens"), par,
   prob = c(0.025, 0.5, 0.975), keep.comp.prob = FALSE, info,
   silent = FALSE, \dots)
}
\arguments{
  \item{object}{an object of apropriate class.}
  \item{type}{character string which specifies the type of the
    re-labeling algorithm.}
  \item{par}{additional parameters for particular re-labeling
    algorithms.

    \describe{
      \item{mean}{\code{par} specifies margin which is used to order the
	components. It is set to 1 if not given.}
      \item{weight}{\code{par} is empty.}
      \item{stephens}{\code{par} is a list with components
        \code{type.init}, \code{par}, \code{maxiter}.

        Component \code{type.init} is a character string being equal to
	either of \dQuote{identity}, \dQuote{mean}, \dQuote{weight}. It
	determines the way which is used to obtain initial re-labeling.

	Component \code{par} determines the margin in the case that
	\code{type.init} is equal to \dQuote{mean}.

	Component \code{maxiter} determines maximum number of iterations
	of the re-labeling algorithm.		
      }
    }  
  }
  \item{prob}{probabilities for which the posterior quantiles
     of component allocation probabilities are computed.
  }
  \item{keep.comp.prob}{logical. If \code{TRUE}, posterior sample of
    component allocation probabilities (for each subject) is kept in the resulting object.}
  \item{info}{number which specifies frequency used to re-display the
    iteration counter during the computation.
  }
  \item{silent}{a logical value indicating whether the information on
    the MCMC progress is to be supressed.}  
  \item{\dots}{optional additional arguments.}
}  
\value{
  An object being equal to the value of the \code{object} argument in
  which the following components are updated according to new labeling
  of the mixture components.
}
\section{Value for NMixMCMC object}{
  When the argument \code{object} is of class \code{NMixMCMC}, the
  resulting object is equal to \code{object} with the following
  components being modified:
  \describe{
    \item{relabel}{see \code{\link{NMixMCMC}}}
    \item{order}{see \code{\link{NMixMCMC}}}
    \item{rank}{see \code{\link{NMixMCMC}}}
    \item{poster.mean.w}{see \code{\link{NMixMCMC}}}
    \item{poster.mean.mu}{see \code{\link{NMixMCMC}}}
    \item{poster.mean.Q}{see \code{\link{NMixMCMC}}}
    \item{poster.mean.Sigma}{see \code{\link{NMixMCMC}}}
    \item{poster.mean.Li}{see \code{\link{NMixMCMC}}}
    \item{poster.comp.prob1}{see \code{\link{NMixMCMC}}}
    \item{poster.comp.prob2}{see \code{\link{NMixMCMC}}}
  }
  Additionally, new components are added, namely
  \describe{
    \item{quant.comp.prob2}{a list with the posterior quantiles of
      component probabilities. One \code{list} component for each
      quantile specified by \code{prob} argument.}
    \item{comp.prob2}{posterior sample of individual component
      probabilities (also given random effects). It is an \eqn{M \times
	n\cdot K}{M x n*K} matrix where \eqn{M} is the length of the
      posterior sample, \eqn{n} is the number of subjects, and \eqn{K}
      is the number of mixture components. Component labels correspond
      to the re-labelled sample. It is included in the
      resulting object only if \code{keep.comp.prob} argument is
      \code{TRUE}.}
  }      
}  
\section{Value for GLMM_MCMC object}{
  When the argument \code{object} is of class \code{GLMM_MCMC}, the
  resulting object is equal to \code{object} with the following
  components being modified:
  \describe{
    \item{relabel_b}{see \code{\link{GLMM_MCMC}}}
    \item{order_b}{see \code{\link{GLMM_MCMC}}}
    \item{rank_b}{see \code{\link{GLMM_MCMC}}}
    \item{poster.mean.w_b}{see \code{\link{GLMM_MCMC}}}
    \item{poster.mean.mu_b}{see \code{\link{GLMM_MCMC}}}
    \item{poster.mean.Q_b}{see \code{\link{GLMM_MCMC}}}
    \item{poster.mean.Sigma_b}{see \code{\link{GLMM_MCMC}}}
    \item{poster.mean.Li_b}{see \code{\link{GLMM_MCMC}}}
    \item{poster.comp.prob1}{see \code{\link{GLMM_MCMC}}}
    \item{poster.comp.prob2}{see \code{\link{GLMM_MCMC}}}
  }
  Additionally, new components are added, namely
  \describe{
    \item{quant.comp.prob2}{a list with the posterior quantiles of
      component probabilities. One \code{list} component for each
      quantile specified by \code{prob} argument.}
    \item{comp.prob2}{posterior sample of individual component
      probabilities (also given random effects). It is an \eqn{M \times
	I\cdot K}{M x I*K} matrix where \eqn{M} is the length of the
      posterior sample, \eqn{I} is the number of subjects, and \eqn{K}
      is the number of mixture components. Component labels correspond
      to the re-labelled sample. It is included in the
      resulting object only if \code{keep.comp.prob} argument is
      \code{TRUE}.}
    \item{poster.comp.prob3}{a matrix with the posterior means of
      component probabilities which are calculated with random effects
      integrated out.}
    \item{quant.comp.prob3}{a list with the posterior quantiles of
      component probabilities. One \code{list} component for each
      quantile specified by \code{prob} argument.}
    \item{comp.prob3}{posterior sample of individual component
      probabilities (with random effects integrated out). It is an \eqn{M \times
	I\cdot K}{M x I*K} matrix where \eqn{M} is the length of the
      posterior sample, \eqn{I} is the number of subjects, and \eqn{K}
      is the number of mixture components. Component labels correspond
      to the re-labelled sample. It is included in the
      resulting object only if \code{keep.comp.prob} argument is
      \code{TRUE}.

      \bold{Remark.} These are the component probabilities which should
      normally be used for clustering purposes.
    }    
  }    
}  
\references{
  Celeux, G. (1998).
  Bayesian inference for mixtures: The label-switching problem.
  In: \emph{COMPSTAT 98} (eds. R. Payne and P. Green),
  pp. 227-232. Heidelberg: Physica-Verlag.

  Jasra, A., Holmes, C. C., and Stephens, D. A. (2005).
  Markov chain Monte Carlo methods and the label switching problem in
  Bayesian mixture modeling.
  \emph{Statistical Science}, \bold{20}, 50-67.
  
  Stephens, M. (1997).
  \emph{Bayesian methods for mixtures of normal distributions. DPhil Thesis.}
  Oxford: University of Oxford.
  (Available from:
  \url{http://www.stat.washington.edu/stephens/papers.html}  (accessed
  on 08/02/2010)).
  
  Stephens, M. (2000).
  Dealing with label switching in mixture models.
  \emph{Journal of the Royal Statistical Society, Series B}, \bold{62}, 795-809.
}
\seealso{
  \code{\link{NMixMCMC}}, \code{\link{GLMM_MCMC}}.
}
\author{
  Arnošt Komárek \email{arnost.komarek[AT]mff.cuni.cz}
}  
\examples{
## See also additional material available in 
## YOUR_R_DIR/library/mixAK/doc/
## or YOUR_R_DIR/site-library/mixAK/doc/
## - file PBCseq.R and
##   http://www.karlin.mff.cuni.cz/~komarek/software/mixAK/PBCseq.pdf
##
## ==============================================
}
\keyword{multivariate}
\keyword{cluster}
