% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.selectEM.R
\name{plot.selectEM}
\alias{plot.selectEM}
\title{Plot Method for Class \code{selectEM}}
\usage{
\method{plot}{selectEM}(x, leg.loc = "topright", ...)
}
\arguments{
\item{x}{an object of class \code{selectEM}, which is an output of the function \code{\link{select}}.}

\item{leg.loc}{the location of the legend, which is the same as the first argument of the function}

\item{...}{other arguments passed to \code{plot}
\code{\link{legend}}. The default value is "topright". The user can change its location
(to "topleft", "bottom right" etc.) if the visual plot conflicts with the legend.}
}
\description{
This function plots the result of mixture model selection by BIC.
}
\details{
The function \code{plot.selectEM} is the plot method for the class \code{selectEM}. It plots
the number of components against the corresponding value of BIC. It is used to visually display
the mixture model selection result by BIC.
}
\examples{
x <- rmixnormal(200, c(0.3, 0.7), c(2, 5), c(1, 1))
res <- select(x, ncomp = 1:3)
plot(res)

}
\seealso{
\code{\link{select}}
}
