% Generated by roxygen2 (4.0.2): do not edit by hand
\name{vizTheta}
\alias{vizTheta}
\title{Mixed Membership Visualization}
\usage{
vizTheta(model, compare = NULL, main = "Estimated Theta", varNames = NULL,
  groupNames = NULL, nrow = NULL, fitNames = NULL, indices = NULL)
}
\arguments{
\item{model}{the \code{mixedMemModel} object that will be plotted}

\item{compare}{estimates to compare against. Should be an array with same dimensions as model$theta}

\item{main}{title of plot}

\item{varNames}{vector specifying labels for each variable}

\item{groupNames}{vector specifying labels for each sub-population}

\item{nrow}{the number of rows in each plot. If the argument is not specified, all variables will appear in one plot}

\item{fitNames}{the names of the models plotted}

\item{indices}{a vector which indicates specific variables to plot. If the argument is not specified, all variables will be plotted}
}
\description{
Plots \eqn{\theta}, the parameters which govern the distributions of variables in a mixed membership model. \eqn{\theta_{j,k}} governs the
distribution of variable j for sub-population k. The model fit is shown in black, and the comparison (if available) is shown in red.
}
\details{
This is the function called by the plot generic function for mixedMemModel objects
}

