\name{plot.mixresid}
\alias{plot.mixresid}
\title{
Plot residuals for a fitted mixture of linear regressions.
}
\description{
Plots the residuals against predictors or fitted values using symbols
whose size is proportional to the probability that the associated
observation was generated by the associated component of the model.
}
\usage{
\method{plot}{mixresid}(x, vsFit=FALSE, whichx=1,digits=2,
                        shape=c("disc","lozenge","square","none"),
                        ngon=20, size=1, gexp=1, polycol=NULL,
                        xlab=NULL, \dots)
}
\arguments{
\item{x}{
An object of class \code{"mixresid"}, which consists of
a list with entries providing the residuals, the relevant
probabilities, the predictors, and the observations, as returned
by \code{residuals.mixreg()}.  When plotting against fitted values,
it is probably better to used the standardized residuals,
i.e. \code{residuals.mixreg()} should be called with \code{std=TRUE}.
}
\item{vsFit}{
Logical scalar;  should the residuals be plotted against the
fitted values?
}
\item{whichx}{
Integer scalar that indicates which predictor to plot against if
there is more than one predictor.  I.e. \code{whichx} indicates
which column of the \code{x} matrix to use.  If \code{vsFit} is
\code{TRUE}, then \code{whichx} is ignored.
}
\item{digits}{
Integer scalar giving the number of digits to which the fitted
values should be rounded when these values are used as axis labels.
Such use occurs only when there are no predictors in the model
(i.e. when the formula is of the form \code{y ~ 1} --- so that
there is a single fitted value for each component) and when
\code{vsFit} is \code{TRUE}.  In all other circumstances \code{digits}
is ignored.
}
\item{shape}{
Character string indicating the shape of the plotting symbol; may
be abbreviated, e.g. to \code{"d"}, \code{"l"}, \code{"s"} or
\code{"n"}.  If \code{shape} is \code{"none"} then \dQuote{ordinary}
plotting is done, using the usual plotting symbols etc.  This can
be much faster, but somewhat defeats the purpose of this plotting
function in that the resulting plots can be misleading.  Using
\code{shape="n"} allows the user to compare the misleading result
with plots in which \dQuote{improbable} residuals are downweighted.
}
\item{ngon}{
The \code{"disc"} shape is actually a regular polygon; \code{ngon}
specifies how many sides it should have; ignored if \code{shape}
is not equal to \code{"disc"}.
}
\item{size}{
Positive numeric scalar.  A scale factor to change the absolute
sizes of the plotting symbols; values larger than 1 make the symbols
larger; values less than 1 make them smaller.
}
\item{gexp}{
Non-negative numeric scalar (\dQuote{gamma exponent}).  The
power to which the conditional \dQuote{component probabilities}
\eqn{\gamma_{ij}}{gamma[i,j]} should be raised.  The default value
1 causes the area of the plotting symbol to be proportional to the
probability.  Setting \code{gexp=0.5} effectively causes the diameter
of the plotting symbol to be proportional to the probability.
Setting \code{gexp=3} causes the area of the plotting symbol to
be proportional to the square of the probability.  Increasing
\code{gexp} decreases the visual impact of plotted points with low
probability, and vice versa.  Setting \code{gexp=0} has effectively
the same impact as setting \code{shape="none"}.
}
\item{polycol}{
Character string specifying the colour in which polygons are plotted.
This encompasses both the colour of the border of the polygon
(specified as \code{border} argument in \code{\link{polygon}()})
and and the \dQuote{fill} colour (specified as \code{col} argument
in \code{polygon()}).  Note that the border colour and fill colour
are hard-wired to be the same in this function --- there is no
option to make them different.  The \dQuote{exception} to this
rule results from using the default value of \code{polycol}, i.e.
\code{NULL}.  This causes the border colour to be \code{par("fg")}
(usually black) and the polygons not to be filled (so that the fill
colour is \dQuote{transparent}, i.e. in effect (usually) white.
}

\item{xlab}{
The \eqn{x} label for the plot; defaults to \code{"x"} unless
\code{vsFit} is \code{TRUE}, in which case it defaults to
\code{"fitted values"}.
}
\item{...}{
Additional arguments (e.g. \code{pch}, \code{col}, \code{cex},
\dots) to be passed to the \code{points()} function which actually
plots the points when \code{shape="none"}.
}}
\section{Side Effects}{
A residual plot is produced in whatever device is currently open.
}
\value{
None.  This function is called for its side effect of drawing
a residual plot.
}
\details{
This function is a "method" for plot.  The plot produced is visually
assessed by ignoring or discounting small symbols.

The label for the \eqn{x}-axis (\dQuote{\code{xlab}}) is by default
taken from the \code{vnms} component of the object being plotted.
If you find this label to be unsatisfactory, supply the argument
\code{xlab}.
}
\author{Rolf Turner
  \email{r.turner@auckland.ac.nz}
}
\references{
T. Rolf Turner (2000). Estimating the rate of spread of a
viral infection of potato plants via mixtures of regressions.
\emph{Applied Statistics} \bold{49} Part 3, pp. 371 -- 384.
}
\section{ACKNOWLEDGEMENT}{
The idea of creating residual plots for regression mixtures by making
the symbol size proportional to the associated probability is due
to Prof. Adrian Baddeley who was, at the time, at the University
of Western Australia. He is now (2021) at Curtin University.
}
\seealso{
\code{\link{mixreg}()},
\code{\link{residuals.mixreg}()}
\code{\link{cband}()},
\code{\link{plot.cband}()},
\code{\link{qqMix}()}
}
\examples{
    thStrt <- list(list(beta=c(3.0,0.1),sigsq=16,lambda=0.5),
                   list(beta=c(0.0,0.0),sigsq=16,lambda=0.5))
    fit    <- mixreg(aphRel,plntsInf,ncomp=2,thetaStart=thStrt,data=aphids)
    rrr    <- residuals(fit)
    plot(rrr)
    plot(rrr,shape="n")
# The plot with shape="n" gives an impression that variability
# increases with aphRel; the plot with default shape ("disc")
# does not give that impression
    rrs    <- residuals(fit,std=TRUE)
    plot(rrs,vsFit=TRUE)
    plot(rrs,vsFit=TRUE,shape="n")
    fit <- mixreg(plntsInf ~ 1,data=aphids,ncomp=2)
    rrr <- residuals(fit,std=TRUE)
    plot(rrr,vsFit=TRUE,digits=4,polycol="blue")
}
\keyword{models}
\keyword{regression}
\keyword{hplot}
