% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{globalearthquake}
\alias{globalearthquake}
\title{Significant Earthquake Dataset}
\format{
A data frame with 98785 rows and 12 variables:
\describe{
\item{date_time}{Date and time in POSIXct format}
\item{latitude}{latitude of the earthquake, from -90° to 90°}
\item{longitude}{longitude of the earthquake, from -180° to 180°}
\item{mag}{the magnitude of the earthquake, indicating its strenth}
\item{Date}{date when the seisme occured}
\item{nbweeks}{number of weeks since 1900/01/01}
\item{year}{year}
\item{month}{month of the year}
\item{month_day}{day of the month}
\item{week}{week number}
\item{week_day}{day of the week from 1 = Sunday to 7 = Saturday}
\item{year_day}{day of the year from 1 to 366}
}
}
\source{
Earthquake Catalog, U.S. Geological Survey, Department of the Interior.
\url{https://www.usgs.gov/programs/earthquake-hazards}
}
\usage{
globalearthquake
}
\description{
A data set containing Earthquake that have occured during the period of
1900-2022 with GPS coordinates and magnitudes.
}
\details{
This is a compiled version of the full data set available on
\href{https://www.usgs.gov/programs/earthquake-hazards}{U.S. Geological Survey Earthquake Events}
(USGS) which is in the
\href{https://www.usgs.gov/information-policies-and-instructions/copyrights-and-credits}{public domain}.

The data set contains only the earthquake between 1900 and 2022
with a magnitude higher than 5.
}
\keyword{datasets}
