% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MizerParams-class.R
\docType{methods}
\name{MizerParams}
\alias{MizerParams}
\alias{MizerParams,numeric,missing-method}
\alias{MizerParams,data.frame,matrix-method}
\alias{MizerParams,data.frame,missing-method}
\title{Constructors for objects of \code{MizerParams} class}
\usage{
MizerParams(object, interaction, ...)

\S4method{MizerParams}{numeric,missing}(object, min_w = 0.001, max_w = 1000,
  no_w = 100, min_w_pp = 1e-10, no_w_pp = NA, species_names = 1:object,
  gear_names = species_names)

\S4method{MizerParams}{data.frame,matrix}(object, interaction, n = 2/3,
  p = 0.7, q = 0.8, r_pp = 10, kappa = 1e+11, lambda = (2 + q - n),
  w_pp_cutoff = 10, max_w = max(object$w_inf) * 1.1, f0 = 0.6,
  z0pre = 0.6, z0exp = n - 1, ...)

\S4method{MizerParams}{data.frame,missing}(object, interaction, ...)
}
\arguments{
\item{object}{A data frame of species specific parameter values (see notes
below).}

\item{interaction}{Optional argument to specify the interaction matrix of the
species (predator by prey). If missing a default interaction is used where
all interactions between species are set to 1. Note that any dimnames of
the interaction matrix argument are ignored by the constructor. The
dimnames of the interaction matrix in the returned \code{MizerParams}
object are taken from the species names in the \code{species_params} slot.
This means that the order of the columns and rows of the interaction matrix
argument should be the same as the species name in the
\code{species_params} slot.}

\item{...}{Additional arguments.}

\item{min_w}{The smallest size of the community spectrum.}

\item{max_w}{The largest size of the community spectrum.
Default value is the largest w_inf in the community x 1.1.}

\item{no_w}{The number of size bins in the community spectrum.}

\item{min_w_pp}{The smallest size of the background spectrum.}

\item{no_w_pp}{Obsolete argument that is no longer used because the number
of plankton size bins is determined because all size bins have to
be logarithmically equally spaced.}

\item{species_names}{Names of the species. Generally not needed as normally
taken from the \code{object} data.frame.}

\item{gear_names}{Names of the gears that catch each species. Generally not
needed as normally taken from the \code{object} data.frame. Default is
\code{species_names}.}

\item{n}{Scaling of the intake. Default value is 2/3.}

\item{p}{Scaling of the standard metabolism. Default value is 0.7.}

\item{q}{Exponent of the search volume. Default value is 0.8.}

\item{r_pp}{Growth rate of the primary productivity. Default value is 10.}

\item{kappa}{Carrying capacity of the resource spectrum. Default
value is 1e11.}

\item{lambda}{Exponent of the resource spectrum. Default value is
(2+q-n).}

\item{w_pp_cutoff}{The cut off size of the background spectrum.
Default value is 10.}

\item{f0}{Average feeding level. Used to calculated \code{h} and
\code{gamma} if those are not columns in the species data frame. Also
requires \code{k_vb} (the von Bertalanffy K parameter) to be a column
in the species data frame. If \code{h} and \code{gamma} are supplied
then this argument is ignored. Default is 0.6..}

\item{z0pre}{If \code{z0}, the mortality from other sources, is not
a column in the species data frame, it is calculated as 
z0pre * w_inf ^ z0exp. Default value is 0.6.}

\item{z0exp}{If \code{z0}, the mortality from other sources, is not
a column in the species data frame, it is calculated as 
z0pre * w_inf ^ z0exp. Default value is n-1.}
}
\value{
An object of type \code{MizerParams}
}
\description{
Constructor method for the \linkS4class{MizerParams} class. Provides the
simplest way of making a \code{MizerParams} object to be used in a
simulation.

Only really used to make MizerParams of the right size and shouldn't be used
by user

Constructor that takes the species_params data.frame and the interaction matrix

Constructor based on the species_params data.frame only with no interaction
}
\note{
The only essential argument to the \code{MizerParams} constructor is a
  data frame which contains the species data. The data frame is arranged
  species by parameter, so each column of the parameter data frame is a
  parameter and each row has the parameters for one of the species in the
  model.
  
  There are some essential columns that must be included in the parameter
  data.frame and that do not have default values. Other columns do have
  default values, so that if they are not included in the species parameter
  data frame, they will be automatically added when the \code{MizerParams}
  object is created. See the accompanying vignette for details of these
  columns.

An additional constructor method which takes an integer of the number of
species in the model. This is only used in internally to set up a
\code{MizerParams} object with the correct dimensions. It is not recommended
that this method is used by users.
}
\examples{
data(NS_species_params_gears)
data(inter)
params <- MizerParams(NS_species_params_gears, inter)
}
\seealso{
\code{\link{project}} \linkS4class{MizerSim}
}
