% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tracking-fluent.R
\name{mlflow_log_artifact}
\alias{mlflow_log_artifact}
\title{Log Artifact}
\usage{
mlflow_log_artifact(path, artifact_path = NULL)
}
\arguments{
\item{path}{The file or directory to log as an artifact.}

\item{artifact_path}{Destination path within the run’s artifact URI.}
}
\description{
Logs an specific file or directory as an artifact.
}
\details{
The fluent API family of functions operate with an implied MLflow client
  determined by the service set by `mlflow_set_tracking_uri()`. For operations
  involving a run it adopts the current active run, or, if one does not exist,
  starts one through the implied service.

When logging to Amazon S3, ensure that the user has a proper policy
attach to it, for instance:

\code{
{
"Version": "2012-10-17",
"Statement": [
  {
    "Sid": "VisualEditor0",
    "Effect": "Allow",
    "Action": [
      "s3:PutObject",
      "s3:GetObject",
      "s3:ListBucket",
      "s3:GetBucketLocation"
      ],
    "Resource": [
      "arn:aws:s3:::mlflow-test/*",
      "arn:aws:s3:::mlflow-test"
      ]
  }
  ]
}
}

Additionally, at least the \code{AWS_ACCESS_KEY_ID} and \code{AWS_SECRET_ACCESS_KEY}
environment variables must be set to the corresponding key and secrets provided
by Amazon IAM.
}
\seealso{
Other Fluent API functions: \code{\link{mlflow_create_experiment}},
  \code{\link{mlflow_end_run}},
  \code{\link{mlflow_log_metric}},
  \code{\link{mlflow_log_param}},
  \code{\link{mlflow_set_experiment}},
  \code{\link{mlflow_set_tag}},
  \code{\link{mlflow_start_run}}
}
\concept{Fluent API functions}
