% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tracking-runs.R
\name{mlflow_start_run}
\alias{mlflow_start_run}
\title{Start Run}
\usage{
mlflow_start_run(
  run_id = NULL,
  experiment_id = NULL,
  start_time = NULL,
  tags = NULL,
  client = NULL,
  nested = FALSE
)
}
\arguments{
\item{run_id}{If specified, get the run with the specified UUID and log metrics
and params under that run. The run's end time is unset and its status is set to
running, but the run's other attributes remain unchanged.}

\item{experiment_id}{Used only when `run_id` is unspecified. ID of the experiment under
which to create the current run. If unspecified, the run is created under
a new experiment with a randomly generated name.}

\item{start_time}{Unix timestamp of when the run started in milliseconds. Only used when `client` is specified.}

\item{tags}{Additional metadata for run in key-value pairs. Only used when `client` is specified.}

\item{client}{(Optional) An MLflow client object returned from \link[mlflow]{mlflow_client}.
If specified, MLflow will use the tracking server associated with the passed-in client. If
unspecified (the common case),
MLflow will use the tracking server associated with the current tracking URI.}

\item{nested}{Controls whether the run to be started is nested in a parent run. `TRUE` creates a nest run.}
}
\description{
Starts a new run. If `client` is not provided, this function infers contextual information such as
  source name and version, and also registers the created run as the active run. If `client` is provided,
  no inference is done, and additional arguments such as `start_time` can be provided.
}
\examples{
\dontrun{
with(mlflow_start_run(), {
  mlflow_log_metric("test", 10)
})
}

}
