% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulation.R
\name{as.data.frame.mp_power}
\alias{as.data.frame.mp_power}
\title{Coerce a \code{\link{mp_power}} to a Data Frame}
\usage{
\method{as.data.frame}{mp_power}(x, row.names = NULL, optional = FALSE, power = TRUE, ...)
}
\arguments{
\item{x}{a \code{\link{mp_power}}.}

\item{row.names}{passed to \code{\link[base:as.data.frame]{base::as.data.frame}}}

\item{optional}{passed to \code{\link[base:as.data.frame]{base::as.data.frame}}}

\item{power}{logical: do you want the power or the estimates}

\item{...}{other arguments not used by this method.}
}
\value{
returns a data frame
}
\description{
Outputs \code{\link{mp_power}} as a data frame.
}
\examples{
# Create Model
model <- (
    outcome('Y')
    + within_predictor('X')
    + effect_size(icc = 0.1)
)
# Set seed
set.seed(19723)
# Create data set and analyze
# Note: Generally Use more than 50 replications
model |> power_analysis(50, 5, 50) -> powersim
# Obtain Results as a data frame
as.data.frame(powersim)
}
