% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f4_classifier.R
\encoding{UTF-8}
\name{f4_classifier}
\alias{f4_classifier}
\title{Constructs the F4 classifier of López-Oriona and Vilar (2021)}
\usage{
f4_classifier(
  training_data,
  new_data = NULL,
  classes,
  levels = c(0.1, 0.5, 0.9),
  cv_folds = 5,
  var_rate = 0.9
)
}
\arguments{
\item{training_data}{A list of MTS constituting the training set to fit
classifier F4.}

\item{new_data}{A list of MTS for which the class labels have to be predicted.}

\item{classes}{A vector containing the class labels associated with the
elements in \code{training_data}.}

\item{levels}{The set of probability levels to compute the QCD-estimates.}

\item{cv_folds}{The number of folds concerning the cross-validation
procedure used to fit F4 with respect to \code{training_data}.}

\item{var_rate}{Rate of desired variability to select the principal
components associated with the QCD-based features.}
}
\value{
If \code{new_data = NULL} (default), returns a fitted model of class
\code{train} (see \code{\link[caret]{train}}). Otherwise, the function
returns the predicted class labels for the elements in \code{new_data}.
}
\description{
\code{f4_classifier} computes the F4 classifier for MTS proposed
by \insertCite{lopez2021f4;textual}{mlmts}.
}
\details{
This function constructs the classifier F4 of . Given a set of MTS with
associated class labels, estimates of the quantile cross-spectral density (QCD)
and the maximum overlap discrete wavelet transform (MODWT) are first computed for each series. Then
Principal Components Analysis (PCA) is applied over the dataset of QCD-based
features and a given number of principal components are retained according to a criterion of
explained variability. Next, each series is decribed by means of the concatenation
of the QCD-based transformed features and the MODWT-based features. Finally, a traditional
random forest classifier is executed in the resulting dataset.
}
\examples{
predictions <- f4_classifier(training_data = Libras$data[1 : 20],
new_data = Libras$data[181 : 200], classes = Libras$classes[181 : 200])
# Computing the predictions for the test set of dataset Libras
}
\references{
{

  \insertRef{lopez2021f4}{mlmts}

}
}
\author{
Ángel López-Oriona, José A. Vilar
}
