\name{logsum}
\alias{logsum}

\title{Compute the log-sum or inclusive value/utility}

\description{The \code{logsum} function computes the inclusive value, or
  inclusive utility, which is used to compute the surplus and to
  estimate the two steps nested logit model.  
}
\usage{
    logsum(coef, X = NULL, formula = NULL, data = NULL,
           type = NULL, output = c("chid", "obs"))
}
\arguments{
  \item{coef}{a numerical vector or a \code{mlogit} object, from which
    the \code{coef} vector is extracted,}
  \item{X}{a matrix or a \code{mlogit} object from which the
    \code{model.matrix} is extracted,}
  \item{formula}{a formula or a \code{mlogit} object from which the
    \code{formula} is extracted,}
  \item{data}{a \code{data.frame} or a \code{mlogit} object from which the
    \code{model.frame} is extracted,}
  \item{type}{either \code{"group"} or \code{"global"} :  if a
    \code{group} argument has been provided in the \code{mlogit.data},
    the inclusive values are by default computed for every group,
    otherwise, a unique global inclusive value is computed for each
    choice situation,}
  \item{output}{the shape of the results: if \code{"chid"}, the results
    is a vector (if \code{type = "global"}) or a matrix (if \code{type =
      "region"}) with row number equal to the number of choice
    situation, if \code{"obs"} a vector of length equal to the number of
    lines of the data in long format is returned.}
}
\value{
  either a vector or a matrix.
}

\details{
  The inclusive value, or inclusive utility, or log-sum is the log of
  the denominator of the probabilities of the multinomial logit
  model. If a \code{"group"} variable is provided in the
  \code{"mlogit.data"} function, the denominator can either be the one
  of the multinomial model or those of the lower model of the nested
  logit model.

  If only one argument (\code{coef}) is provided, it should a
  \code{mlogit} object and in this case, the \code{coefficients} and the
  \code{model.matrix} are extracted from this model.

  In order to provide a different \code{model.matrix}, further arguments
  could be used. \code{X} is a \code{matrix} or a \code{mlogit} from
  which the \code{model.matrix} is extracted. The
  \code{formula}-\code{data} interface can also be used to construct the
  relevant \code{model.matrix}.

}
\seealso{
  \code{\link{mlogit}} for the estimation of a multinomial logit model.
}

\author{Yves Croissant}
\keyword{regression}
