/**
 * @file src/approx_kfn.cpp
 *
 * This is an autogenerated file containing implementations of C++ functions to
 * be called by the R approx_kfn binding.
 */
#include <rcpp_mlpack.h>
#define BINDING_TYPE BINDING_TYPE_R
#include <mlpack/methods/approx_kfn/approx_kfn_main.cpp>

#define Realloc(p,n,t) (t *) R_chk_realloc( (void *)(p), (R_SIZE_T)((n) * sizeof(t)) )
#define Free(p)        (R_chk_free( (void *)(p) ), (p) = NULL)

// [[Rcpp::export]]
void approx_kfn_call(SEXP params, SEXP timers)
{
  util::Params& p = *Rcpp::as<Rcpp::XPtr<util::Params>>(params);
  util::Timers& t = *Rcpp::as<Rcpp::XPtr<util::Timers>>(timers);

  if (p.Has("verbose"))
    Log::Info.ignoreInput = false;
  else
    Log::Info.ignoreInput = true;

  BINDING_FUNCTION(p, t);
}

// Any implementations of methods for dealing with model pointers will be put
// below this comment, if needed.

// Get the pointer to a ApproxKFNModel parameter.
// [[Rcpp::export]]
SEXP GetParamApproxKFNModelPtr(SEXP params,
                                   const std::string& paramName,
                                   SEXP inputModels)
{
  util::Params& p = *Rcpp::as<Rcpp::XPtr<util::Params>>(params);
  Rcpp::List inputModelsList(inputModels);
  ApproxKFNModel* modelPtr = p.Get<ApproxKFNModel*>(paramName);
  for (int i = 0; i < inputModelsList.length(); ++i)
  {
    Rcpp::XPtr<ApproxKFNModel> inputModel =
        Rcpp::as<Rcpp::XPtr<ApproxKFNModel>>(inputModelsList[i]);
    // Don't create a new XPtr---just reuse the one given as input, so that we
    // don't end up deleting it twice.
    if (inputModel.get() == modelPtr)
      return inputModel;
  }

  return std::move((Rcpp::XPtr<ApproxKFNModel>) p.Get<ApproxKFNModel*>(paramName));
}

// Set the pointer to a ApproxKFNModel parameter.
// [[Rcpp::export]]
void SetParamApproxKFNModelPtr(SEXP params, const std::string& paramName, SEXP ptr)
{
  util::Params& p = *Rcpp::as<Rcpp::XPtr<util::Params>>(params);
  p.Get<ApproxKFNModel*>(paramName) = Rcpp::as<Rcpp::XPtr<ApproxKFNModel>>(ptr);
  p.SetPassed(paramName);
}

// Serialize a ApproxKFNModel pointer.
// [[Rcpp::export]]
Rcpp::RawVector SerializeApproxKFNModelPtr(SEXP ptr)
{
  std::ostringstream oss;
  {
    cereal::BinaryOutputArchive oa(oss);
    oa(cereal::make_nvp("ApproxKFNModel",
          *Rcpp::as<Rcpp::XPtr<ApproxKFNModel>>(ptr)));
  }

  Rcpp::RawVector raw_vec(oss.str().size());

  // Copy the string buffer so we can return one that won't get deallocated when
  // we exit this function.
  memcpy(&raw_vec[0], oss.str().c_str(), oss.str().size());
  raw_vec.attr("type") = "ApproxKFNModel";
  return raw_vec;
}

// Deserialize a ApproxKFNModel pointer.
// [[Rcpp::export]]
SEXP DeserializeApproxKFNModelPtr(Rcpp::RawVector str)
{
  ApproxKFNModel* ptr = new ApproxKFNModel();

  std::istringstream iss(std::string((char *) &str[0], str.size()));
  {
    cereal::BinaryInputArchive ia(iss);
    ia(cereal::make_nvp("ApproxKFNModel", *ptr));
  }

  // R will be responsible for freeing this.
  return std::move((Rcpp::XPtr<ApproxKFNModel>)ptr);
}


