% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/configureMlr.R
\name{configureMlr}
\alias{configureMlr}
\title{Configures the behavior of the package.}
\usage{
configureMlr(show.info, on.learner.error, on.learner.warning,
  on.par.without.desc, on.par.out.of.bounds, on.measure.not.applicable,
  show.learner.output, on.error.dump)
}
\arguments{
\item{show.info}{[\code{logical(1)}]\cr
Some methods of mlr support a \code{show.info} argument to enable
verbose output on the console. This option sets the default value for these arguments.
Setting the argument manually in one of these functions will overwrite the default
value for that specific function call.
Default is \code{TRUE}.}

\item{on.learner.error}{[\code{character(1)}]\cr
What should happen if an error in an underlying learning algorithm is caught:\cr
\dQuote{stop}: R exception is generated.\cr
\dQuote{warn}: A \code{FailureModel} will be created, which predicts only NAs and a warning will be generated.\cr
\dQuote{quiet}: Same as \dQuote{warn} but without the warning.\cr
Default is \dQuote{stop}.}

\item{on.learner.warning}{[\code{character(1)}]\cr
What should happen if a warning in an underlying learning algorithm is generated:\cr
\dQuote{warn}: The warning is generated as usual.\cr
\dQuote{quiet}: The warning is suppressed.\cr
Default is \dQuote{warn}.}

\item{on.par.without.desc}{[\code{character(1)}]\cr
What should happen if a parameter of a learner is set to a value, but no parameter description object exists,
indicating a possibly wrong name:\cr
\dQuote{stop}: R exception is generated.\cr
\dQuote{warn}: Warning, but parameter is still passed along to learner.\cr
\dQuote{quiet}: Same as \dQuote{warn} but without the warning.\cr
Default is \dQuote{stop}.}

\item{on.par.out.of.bounds}{[\code{character(1)}]\cr
What should happen if a parameter of a learner is set to an out of bounds value.\cr
\dQuote{stop}: R exception is generated.\cr
\dQuote{warn}: Warning, but parameter is still passed along to learner.\cr
\dQuote{quiet}: Same as \dQuote{warn} but without the warning.\cr
Default is \dQuote{stop}.}

\item{on.measure.not.applicable}{[\code{logical(1)}]\cr
What should happen if a measure is not applicable to a learner.\cr
\dQuote{stop}: R exception is generated.\cr
\dQuote{warn}: Warning, but value of the measure will be \code{NA}.\cr
\dQuote{quiet}: Same as \dQuote{warn} but without the warning.\cr
Default is \dQuote{stop}.}

\item{show.learner.output}{[\code{logical(1)}]\cr
Should the output of the learning algorithm during training and prediction be shown or captured and
suppressed?
Default is \code{TRUE}.}

\item{on.error.dump}{[\code{logical(1)}]\cr
Specify whether \code{\link{FailureModel}} models and failed predictions should contain an error dump
that can be used with \code{debugger} to inspect an error. This option is only effective if \code{on.learner.error}
is \dQuote{warn} or \dQuote{quiet}. If it is \code{TRUE}, the dump can be accessed using 
\code{\link{getFailureModelDump}} on the \code{\link{FailureModel}}, \code{\link{getPredictionDump}} on the failed prediction, and \code{\link{getRRDump}} on resample predictions.
Default is \code{FALSE}.}
}
\value{
[\code{invisible(NULL)}].
}
\description{
Configuration is done by setting custom \code{\link{options}}.

If you do not set an option here, its current value will be kept.

If you call this function with an empty argument list, everything is set to its defaults.
}
\seealso{
Other configure: \code{\link{getMlrOptions}}
}
