% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generateFilterValues.R
\name{generateFilterValuesData}
\alias{FilterValues}
\alias{generateFilterValuesData}
\title{Calculates feature filter values.}
\usage{
generateFilterValuesData(task, method = "rf.importance",
  nselect = getTaskNFeats(task), ...)
}
\arguments{
\item{task}{[\code{\link{Task}}]\cr
The task.}

\item{method}{[\code{character}]\cr
Filter method(s), see above.
Default is \dQuote{rf.importance}.}

\item{nselect}{[\code{integer(1)}]\cr
Number of scores to request. Scores are getting calculated for all features per default.}

\item{...}{[any]\cr
Passed down to selected method.}
}
\value{
[\code{FilterValues}]. A \code{list} containing:
  \item{task.desc}{[\code{\link{TaskDesc}}]\cr
   Task description.}
  \item{data}{[\code{data.frame}] with columns:
    \itemize{
      \item \code{name} Name of feature.
      \item \code{type} Feature column type.
      \item A column for each \code{method} with
                  the feature importance values.
    }}
}
\description{
Calculates numerical filter values for features.
For a list of features, use \code{\link{listFilterMethods}}.
}
\seealso{
Other filter: \code{\link{filterFeatures}},
  \code{\link{getFilterValues}},
  \code{\link{getFilteredFeatures}},
  \code{\link{makeFilterWrapper}},
  \code{\link{plotFilterValuesGGVIS}},
  \code{\link{plotFilterValues}}

Other generate_plot_data: \code{\link{generateCalibrationData}},
  \code{\link{generateCritDifferencesData}},
  \code{\link{generateLearningCurveData}},
  \code{\link{generatePartialPredictionData}},
  \code{\link{generateThreshVsPerfData}},
  \code{\link{getFilterValues}}
}

