% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TaskRegr.R
\docType{data}
\name{TaskRegr}
\alias{TaskRegr}
\title{Regression Task}
\format{\link[R6:R6Class]{R6::R6Class} object inheriting from \link{Task}/\link{TaskSupervised}.}
\description{
This task specializes \link{Task} and \link{TaskSupervised} for regression problems.
The target column is assumed to be numeric.
The \code{task_type} is set to \code{"classif"}.

Predefined tasks are stored in the \link{Dictionary} \link{mlr_tasks}.
}
\section{Construction}{
\preformatted{t = TaskRegr$new(id, backend, target)
}
\itemize{
\item \code{id} :: \code{character(1)}\cr
Identifier for the task.
\item \code{backend} :: (\link{DataBackend} | \code{data.frame()} | ...)\cr
Either a \link{DataBackend}, or any object which is convertible to a DataBackend with \code{as_data_backend()}.
E.g., a \code{data.frame()} will be converted to a \link{DataBackendDataTable}.
\item \code{target} :: \code{character(1)}\cr
Name of the target column.
}
}

\section{Fields}{

See \link{TaskSupervised}.
}

\section{Methods}{

See \link{TaskSupervised}.
}

\examples{
task = TaskRegr$new("iris", backend = iris, target = "Sepal.Length")
task$task_type
task$formula()
task$truth()

# possible properties:
mlr_reflections$task_properties$regr
}
\seealso{
Example regression tasks: \code{\link[=mlr_tasks_boston_housing]{boston_housing}}

Other Task: \code{\link{TaskClassif}},
  \code{\link{TaskSupervised}}, \code{\link{Task}},
  \code{\link{mlr_tasks}}
}
\concept{Task}
\keyword{datasets}
