% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/learner_fairml_regr_fairnclm.R
\name{mlr_learners_regr.fairnclm}
\alias{mlr_learners_regr.fairnclm}
\alias{LearnerRegrFairnclm}
\title{Regression Non-convex Fair Regression Learner}
\description{
Calls \link[fairml:nclm]{fairml::nclm} from package \CRANpkg{fairml}.
}
\details{
Fair regression model based on nonconvex optimization from Komiyama et al. (2018).
Implemented via package \code{fairml}.
The 'unfairness' parameter is set to 0.05 as a default.
}
\section{Dictionary}{
 This \link{Learner} can be instantiated via the
\link[mlr3misc:Dictionary]{dictionary} \link{mlr_learners} or with the associated
sugar function \code{\link[=lrn]{lrn()}}:\preformatted{mlr_learners$get("regr.fairnclm")
lrn("regr.fairnclm")
}
}

\section{Meta Information}{

\itemize{
\item Task type: \dQuote{regr}
\item Predict Types: \dQuote{response}
\item Feature Types: \dQuote{integer}, \dQuote{numeric}, \dQuote{factor}, \dQuote{ordered}
\item Required Packages: \CRANpkg{mlr3}, \CRANpkg{fairml}
}
}

\section{Parameters}{
\tabular{lllll}{
   Id \tab Type \tab Default \tab Levels \tab Range \cr
   lambda \tab numeric \tab 0 \tab  \tab \eqn{[0, \infty)}{[0, Inf)} \cr
   save.auxiliary \tab logical \tab FALSE \tab TRUE, FALSE \tab - \cr
   covfun \tab untyped \tab stats::cov \tab  \tab - \cr
   unfairness \tab numeric \tab - \tab  \tab \eqn{[0, 1]}{[0, 1]} \cr
}
}

\examples{
# stop example failing with warning if package not installed
learner = suppressWarnings(mlr3::lrn("regr.fairnclm"))
print(learner)

# available parameters:
learner$param_set$ids()
}
\references{
J K, A T, J H, H S (2018).
\dQuote{Nonconvex Optimization for Regression with Fairness Constraints.}
In \emph{Proceedings of the 35th International Conference on Machine Learning (ICML), PMLR 80}, 2737-2746.
}
\seealso{
\link[mlr3misc:Dictionary]{Dictionary} of \link[mlr3:Learner]{Learners}:
\link[mlr3:mlr_learners]{mlr3::mlr_learners}

Other fairness_learners: 
\code{\link{mlr_learners_classif.fairfgrrm}},
\code{\link{mlr_learners_classif.fairzlrm}},
\code{\link{mlr_learners_regr.fairfrrm}},
\code{\link{mlr_learners_regr.fairzlm}}
}
\author{
pfistfl
}
\concept{fairness_learners}
\keyword{internal}
\section{Super classes}{
\code{\link[mlr3:Learner]{mlr3::Learner}} -> \code{\link[mlr3:LearnerRegr]{mlr3::LearnerRegr}} -> \code{LearnerRegrFairnclm}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{LearnerRegrFairnclm$new()}}
\item \href{#method-clone}{\code{LearnerRegrFairnclm$clone()}}
}
}
\if{html}{
\out{<details ><summary>Inherited methods</summary>}
\itemize{
\item \out{<span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="base_learner">}\href{../../mlr3/html/Learner.html#method-base_learner}{\code{mlr3::Learner$base_learner()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="format">}\href{../../mlr3/html/Learner.html#method-format}{\code{mlr3::Learner$format()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="help">}\href{../../mlr3/html/Learner.html#method-help}{\code{mlr3::Learner$help()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="predict">}\href{../../mlr3/html/Learner.html#method-predict}{\code{mlr3::Learner$predict()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="predict_newdata">}\href{../../mlr3/html/Learner.html#method-predict_newdata}{\code{mlr3::Learner$predict_newdata()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="print">}\href{../../mlr3/html/Learner.html#method-print}{\code{mlr3::Learner$print()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="reset">}\href{../../mlr3/html/Learner.html#method-reset}{\code{mlr3::Learner$reset()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="train">}\href{../../mlr3/html/Learner.html#method-train}{\code{mlr3::Learner$train()}}\out{</span>}
}
\out{</details>}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Creates a new instance of this \link[R6:R6Class]{R6} class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LearnerRegrFairnclm$new()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LearnerRegrFairnclm$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
