% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FilterCarScore.R
\docType{data}
\name{FilterCarScore}
\alias{FilterCarScore}
\alias{mlr_filters_carscore}
\title{Conditional Mutual Information Based Feature Selection Filter}
\format{\link[R6:R6Class]{R6::R6Class} inheriting from \link{Filter}.}
\description{
Calculates the Correlation-Adjusted (marginal) coRelation scores
(short CAR scores) implemented in \code{\link[care:carscore]{care::carscore()}} in package
\CRANpkg{care}. The CAR scores for a set of features are defined as the
correlations between the target and the decorrelated features. The filter
returns the absolute value of the calculated scores.

Argument \code{verbose} defaults to \code{FALSE}.
}
\section{Construction}{
\preformatted{FilterCarScore$new()
mlr_filters$get("carscore")
flt("carscore")
}
}

\examples{
task = mlr3::tsk("mtcars")
filter = flt("carscore")
filter$calculate(task)
head(as.data.table(filter), 3)

## changing filter settings
filter = flt("carscore")
filter$param_set$values = list("diagonal" = TRUE)
filter$calculate(task)
head(as.data.table(filter), 3)
}
\seealso{
\link[mlr3misc:Dictionary]{Dictionary} of \link[=Filter]{Filters}: \link{mlr_filters}

Other Filter: \code{\link{FilterAUC}},
  \code{\link{FilterAnova}}, \code{\link{FilterCMIM}},
  \code{\link{FilterCorrelation}},
  \code{\link{FilterDISR}}, \code{\link{FilterImportance}},
  \code{\link{FilterInformationGain}},
  \code{\link{FilterJMIM}}, \code{\link{FilterJMI}},
  \code{\link{FilterKruskalTest}}, \code{\link{FilterMIM}},
  \code{\link{FilterMRMR}}, \code{\link{FilterNJMIM}},
  \code{\link{FilterPerformance}},
  \code{\link{FilterVariance}}, \code{\link{Filter}},
  \code{\link{mlr_filters}}
}
\concept{Filter}
\keyword{datasets}
