% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FilterCorrelation.R
\name{FilterCorrelation}
\alias{FilterCorrelation}
\alias{mlr_filters_correlation}
\title{Correlation Filter}
\format{\link[R6:R6Class]{R6::R6Class} inheriting from \link{Filter}.}
\description{
Simple correlation filter calling \code{\link[stats:cor]{stats::cor()}}.
The filter score is the absolute value of the correlation.
}
\section{Construction}{
\preformatted{FilterCorrelation$new()
mlr_filters$get("correlation")
flt("correlation")
}
}

\examples{
## Pearson (default)
task = mlr3::tsk("mtcars")
filter = flt("correlation")
filter$calculate(task)
as.data.table(filter)

## Spearman
filter = FilterCorrelation$new()
filter$param_set$values = list("method" = "spearman")
filter$calculate(task)
as.data.table(filter)
}
\seealso{
\link[mlr3misc:Dictionary]{Dictionary} of \link[=Filter]{Filters}: \link{mlr_filters}

Other Filter: 
\code{\link{FilterAUC}},
\code{\link{FilterAnova}},
\code{\link{FilterCMIM}},
\code{\link{FilterCarScore}},
\code{\link{FilterDISR}},
\code{\link{FilterImportance}},
\code{\link{FilterInformationGain}},
\code{\link{FilterJMIM}},
\code{\link{FilterJMI}},
\code{\link{FilterKruskalTest}},
\code{\link{FilterMIM}},
\code{\link{FilterMRMR}},
\code{\link{FilterNJMIM}},
\code{\link{FilterPerformance}},
\code{\link{FilterVariance}},
\code{\link{Filter}},
\code{\link{mlr_filters}}
}
\concept{Filter}
