% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FSelectorGeneticSearch.R
\name{mlr_fselectors_genetic_search}
\alias{mlr_fselectors_genetic_search}
\alias{FSelectorGeneticSearch}
\title{Feature Selection via Genetic Search}
\description{
Genetic search imitates the process of natural selection to generate feature sets.

Calls \code{\link[genalg:rbga.bin]{genalg::rbga.bin()}} from package \CRANpkg{genalg}.
}
\section{Dictionary}{

This \link{FSelector} can be instantiated via the \link[mlr3misc:Dictionary]{dictionary}
\link{mlr_fselectors} or with the associated sugar function \code{\link[=fs]{fs()}}:

\if{html}{\out{<div class="sourceCode">}}\preformatted{mlr_fselectors$get("genetic_search")
fs("genetic_search")
}\if{html}{\out{</div>}}
}

\section{Parameters}{

\describe{
\item{\code{suggestions}}{\code{list()}}
\item{\code{popSize}}{\code{integer(1)}}
\item{\code{mutationChance}}{\code{numeric(1)}}
\item{\code{elitism}}{\code{integer(1)}}
\item{\code{zeroToOneRatio}}{\code{integer(1)}}
\item{\code{iters}}{\code{integer(1)}}
}

For the meaning of the control parameters, see \code{\link[genalg:rbga.bin]{genalg::rbga.bin()}}.
\code{\link[genalg:rbga.bin]{genalg::rbga.bin()}} internally terminates after \code{iters} iteration.
We set \code{ìters = 100000}  to allow the termination via our terminators.
If more iterations are needed, set \code{ìters} to a higher value in the parameter set.
}

\examples{
# retrieve task
task = tsk("pima")

# load learner
learner = lrn("classif.rpart")

\donttest{
# feature selection on the pima indians diabetes data set
instance = fselect(
  method = "genetic_search",
  task = task,
  learner = learner,
  resampling = rsmp("holdout"),
  measure = msr("classif.ce"),
  term_evals = 10
)

# best performing feature subset
instance$result

# all evaluated feature subsets
as.data.table(instance$archive)

# subset the task and fit the final model
task$select(instance$result_feature_set)
learner$train(task)
}
}
\section{Super class}{
\code{\link[mlr3fselect:FSelector]{mlr3fselect::FSelector}} -> \code{FSelectorGeneticSearch}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-FSelectorGeneticSearch-new}{\code{FSelectorGeneticSearch$new()}}
\item \href{#method-FSelectorGeneticSearch-clone}{\code{FSelectorGeneticSearch$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="mlr3fselect" data-topic="FSelector" data-id="format"><a href='../../mlr3fselect/html/FSelector.html#method-FSelector-format'><code>mlr3fselect::FSelector$format()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3fselect" data-topic="FSelector" data-id="help"><a href='../../mlr3fselect/html/FSelector.html#method-FSelector-help'><code>mlr3fselect::FSelector$help()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3fselect" data-topic="FSelector" data-id="optimize"><a href='../../mlr3fselect/html/FSelector.html#method-FSelector-optimize'><code>mlr3fselect::FSelector$optimize()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3fselect" data-topic="FSelector" data-id="print"><a href='../../mlr3fselect/html/FSelector.html#method-FSelector-print'><code>mlr3fselect::FSelector$print()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FSelectorGeneticSearch-new"></a>}}
\if{latex}{\out{\hypertarget{method-FSelectorGeneticSearch-new}{}}}
\subsection{Method \code{new()}}{
Creates a new instance of this \link[R6:R6Class]{R6} class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FSelectorGeneticSearch$new()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FSelectorGeneticSearch-clone"></a>}}
\if{latex}{\out{\hypertarget{method-FSelectorGeneticSearch-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FSelectorGeneticSearch$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
