% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EnsembleFSResult.R
\name{ensemble_fs_result}
\alias{ensemble_fs_result}
\alias{EnsembleFSResult}
\title{Ensemble Feature Selection Result}
\description{
The \code{EnsembleFSResult} stores the results of ensemble feature selection.
It includes methods for evaluating the stability of the feature selection process and for ranking the selected features among others.
The function \code{\link[=ensemble_fselect]{ensemble_fselect()}} returns an object of this class.
}
\section{S3 Methods}{

\itemize{
\item \code{as.data.table.EnsembleFSResult(x, benchmark_result = TRUE)}\cr
Returns a tabular view of the ensemble feature selection.\cr
\link{EnsembleFSResult} -> \code{\link[data.table:data.table]{data.table::data.table()}}\cr
\itemize{
\item \code{x} (\link{EnsembleFSResult})
\item \code{benchmark_result} (\code{logical(1)})\cr
Whether to add the learner, task and resampling information from the benchmark result.
}
}
}

\examples{
\donttest{
  efsr = ensemble_fselect(
    fselector = fs("rfe", n_features = 2, feature_fraction = 0.8),
    task = tsk("sonar"),
    learners = lrns(c("classif.rpart", "classif.featureless")),
    init_resampling = rsmp("subsampling", repeats = 2),
    inner_resampling = rsmp("cv", folds = 3),
    measure = msr("classif.ce"),
    terminator = trm("none")
  )

  # contains the benchmark result
  efsr$benchmark_result

  # contains the selected features for each iteration
  efsr$result

  # returns the stability of the selected features
  efsr$stability(stability_measure = "jaccard")

  # returns a ranking of all features
  head(efsr$feature_ranking())

  # returns the empirical pareto front (nfeatures vs error)
  efsr$pareto_front()
}
}
\references{
Das, I (1999).
\dQuote{On characterizing the 'knee' of the Pareto curve based on normal-boundary intersection.}
\emph{Structural Optimization}, \bold{18}(1-2), 107--115.
ISSN 09344373.
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{benchmark_result}}{(\link[mlr3:BenchmarkResult]{mlr3::BenchmarkResult})\cr
The benchmark result.}

\item{\code{man}}{(\code{character(1)})\cr
Manual page for this object.}
}
\if{html}{\out{</div>}}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{result}}{(\link[data.table:data.table]{data.table::data.table})\cr
Returns the result of the ensemble feature selection.}

\item{\code{n_learners}}{(\code{numeric(1)})\cr
Returns the number of learners used in the ensemble feature selection.}

\item{\code{measure}}{(\code{character(1)})\cr
Returns the measure id used in the ensemble feature selection.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-EnsembleFSResult-new}{\code{EnsembleFSResult$new()}}
\item \href{#method-EnsembleFSResult-format}{\code{EnsembleFSResult$format()}}
\item \href{#method-EnsembleFSResult-print}{\code{EnsembleFSResult$print()}}
\item \href{#method-EnsembleFSResult-help}{\code{EnsembleFSResult$help()}}
\item \href{#method-EnsembleFSResult-feature_ranking}{\code{EnsembleFSResult$feature_ranking()}}
\item \href{#method-EnsembleFSResult-stability}{\code{EnsembleFSResult$stability()}}
\item \href{#method-EnsembleFSResult-pareto_front}{\code{EnsembleFSResult$pareto_front()}}
\item \href{#method-EnsembleFSResult-knee_points}{\code{EnsembleFSResult$knee_points()}}
\item \href{#method-EnsembleFSResult-clone}{\code{EnsembleFSResult$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-EnsembleFSResult-new"></a>}}
\if{latex}{\out{\hypertarget{method-EnsembleFSResult-new}{}}}
\subsection{Method \code{new()}}{
Creates a new instance of this \link[R6:R6Class]{R6} class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{EnsembleFSResult$new(
  result,
  features,
  benchmark_result = NULL,
  measure_id,
  minimize = TRUE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{result}}{(\link[data.table:data.table]{data.table::data.table})\cr
The result of the ensemble feature selection.
Column names should include \code{"resampling_iteration"}, \code{"learner_id"}, \code{"features"}
and \code{"n_features"}.}

\item{\code{features}}{(\code{\link[=character]{character()}})\cr
The vector of features of the task that was used in the ensemble feature
selection.}

\item{\code{benchmark_result}}{(\link[mlr3:BenchmarkResult]{mlr3::BenchmarkResult})\cr
The benchmark result object.}

\item{\code{measure_id}}{(\code{character(1)})\cr
Column name of \code{"result"} that corresponds to the measure used.}

\item{\code{minimize}}{(\code{logical(1)})\cr
If \code{TRUE} (default), lower values of the measure correspond to higher performance.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-EnsembleFSResult-format"></a>}}
\if{latex}{\out{\hypertarget{method-EnsembleFSResult-format}{}}}
\subsection{Method \code{format()}}{
Helper for print outputs.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{EnsembleFSResult$format(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{(ignored).}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-EnsembleFSResult-print"></a>}}
\if{latex}{\out{\hypertarget{method-EnsembleFSResult-print}{}}}
\subsection{Method \code{print()}}{
Printer.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{EnsembleFSResult$print(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{(ignored).}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-EnsembleFSResult-help"></a>}}
\if{latex}{\out{\hypertarget{method-EnsembleFSResult-help}{}}}
\subsection{Method \code{help()}}{
Opens the corresponding help page referenced by field \verb{$man}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{EnsembleFSResult$help()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-EnsembleFSResult-feature_ranking"></a>}}
\if{latex}{\out{\hypertarget{method-EnsembleFSResult-feature_ranking}{}}}
\subsection{Method \code{feature_ranking()}}{
Calculates the feature ranking.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{EnsembleFSResult$feature_ranking(method = "approval_voting")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{method}}{(\code{character(1)})\cr
The method to calculate the feature ranking.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
The feature ranking process is built on the following framework: models act as voters, features act as candidates, and voters select certain candidates (features).
The primary objective is to compile these selections into a consensus ranked list of features, effectively forming a committee.
Currently, only \code{"approval_voting"} method is supported, which selects the candidates/features that have the highest approval score or selection frequency, i.e. appear the most often.
}

\subsection{Returns}{
A \link[data.table:data.table]{data.table::data.table} listing all the features, ordered by decreasing inclusion probability scores (depending on the \code{method})
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-EnsembleFSResult-stability"></a>}}
\if{latex}{\out{\hypertarget{method-EnsembleFSResult-stability}{}}}
\subsection{Method \code{stability()}}{
Calculates the stability of the selected features with the \CRANpkg{stabm} package.
The results are cached.
When the same stability measure is requested again with different arguments, the cache must be reset.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{EnsembleFSResult$stability(
  stability_measure = "jaccard",
  stability_args = NULL,
  global = TRUE,
  reset_cache = FALSE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{stability_measure}}{(\code{character(1)})\cr
The stability measure to be used.
One of the measures returned by \code{\link[stabm:listStabilityMeasures]{stabm::listStabilityMeasures()}} in lower case.
Default is \code{"jaccard"}.}

\item{\code{stability_args}}{(\code{list})\cr
Additional arguments passed to the stability measure function.}

\item{\code{global}}{(\code{logical(1)})\cr
Whether to calculate the stability globally or for each learner.}

\item{\code{reset_cache}}{(\code{logical(1)})\cr
If \code{TRUE}, the cached results are ignored.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A \code{numeric()} value representing the stability of the selected features.
Or a \code{numeric()} vector with the stability of the selected features for each learner.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-EnsembleFSResult-pareto_front"></a>}}
\if{latex}{\out{\hypertarget{method-EnsembleFSResult-pareto_front}{}}}
\subsection{Method \code{pareto_front()}}{
This function identifies the \strong{Pareto front} of the ensemble feature
selection process, i.e., the set of points that represent the trade-off
between the number of features and performance (e.g. classification error).
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{EnsembleFSResult$pareto_front(type = "empirical")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{type}}{(\code{character(1)})\cr
Specifies the type of Pareto front to return. See details.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Two options are available for the Pareto front:
\itemize{
\item \code{"empirical"} (default): returns the empirical Pareto front.
\item \code{"estimated"}: the Pareto front points are estimated by fitting a linear model with the inversed of the number of features (\eqn{1/x}) as input and the associated performance scores as output.
This method is useful when the Pareto points are sparse and the front  assumes a convex shape if better performance corresponds to lower measure values (e.g. classification error), or a concave shape otherwise (e.g. classification accuracy).
The \code{estimated} Pareto front will include points for a number of features ranging from 1 up to the maximum number found in the empirical Pareto front.
}
}

\subsection{Returns}{
A \link[data.table:data.table]{data.table::data.table} with columns the number of features and the performance that together form the Pareto front.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-EnsembleFSResult-knee_points"></a>}}
\if{latex}{\out{\hypertarget{method-EnsembleFSResult-knee_points}{}}}
\subsection{Method \code{knee_points()}}{
This function implements various \emph{knee} point identification (KPI) methods, which select points in the Pareto front, such that an optimal trade-off between performance and number of features is achieved.
In most cases, only one such point is returned.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{EnsembleFSResult$knee_points(method = "NBI", type = "empirical")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{method}}{(\code{character(1)})\cr
Type of method to use to identify the knee point. See details.}

\item{\code{type}}{(\code{character(1)})\cr
Specifies the type of Pareto front to use for the identification of the knee point.
See \code{pareto_front()} method for more details.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
The available KPI methods are:
\itemize{
\item \code{"NBI"} (default): The \strong{Normal-Boundary Intersection} method is a geometry-based method which calculates the perpendicular distance of each point from the line connecting the first and last points of the Pareto front.
The knee point is determined as the Pareto point with the maximum distance from this line, see Das (1999).
}
}

\subsection{Returns}{
A \link[data.table:data.table]{data.table::data.table} with the knee point(s) of the Pareto front.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-EnsembleFSResult-clone"></a>}}
\if{latex}{\out{\hypertarget{method-EnsembleFSResult-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{EnsembleFSResult$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
