% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LearnerSurvXgboost.R
\name{mlr_learners_surv.xgboost}
\alias{mlr_learners_surv.xgboost}
\alias{LearnerSurvXgboost}
\title{Extreme Gradient Boosting Survival Learner}
\description{
eXtreme Gradient Boosting regression.
Calls \code{\link[xgboost:xgb.train]{xgboost::xgb.train()}} from package \CRANpkg{xgboost}.
}
\section{Custom mlr3 defaults}{

\itemize{
\item \code{nrounds}:
\itemize{
\item Actual default: no default.
\item Adjusted default: 1.
\item Reason for change: Without a default construction of the learner
would error. Just setting a nonsense default to workaround this.
\code{nrounds} needs to be tuned by the user.
}
\item \code{nthread}:
\itemize{
\item Actual value: Undefined, triggering auto-detection of the number of CPUs.
\item Adjusted value: 1.
\item Reason for change: Conflicting with parallelization via \CRANpkg{future}.
}
\item \code{verbose}:
\itemize{
\item Actual default: 1.
\item Adjusted default: 0.
\item Reason for change: Reduce verbosity.
}
\item \code{objective}:
\itemize{
\item Actual default: \code{reg:squarederror}.
\item Adjusted default: \code{survival:cox}.
\item Reason for change: Changed to a survival objective.
}
}
}

\section{Dictionary}{

This \link{Learner} can be instantiated via the \link[mlr3misc:Dictionary]{dictionary} \link{mlr_learners} or with the associated sugar function \code{\link[=lrn]{lrn()}}:\preformatted{mlr_learners$get("surv.xgboost")
lrn("surv.xgboost")
}
}

\section{Meta Information}{

\itemize{
\item Task type: \dQuote{surv}
\item Predict Types: \dQuote{crank}, \dQuote{lp}
\item Feature Types: \dQuote{integer}, \dQuote{numeric}
\item Required Packages: \CRANpkg{mlr3}, \CRANpkg{mlr3learners}, \CRANpkg{xgboost}
}
}

\section{Parameters}{
\tabular{lllll}{
   Id \tab Type \tab Default \tab Levels \tab Range \cr
   aft_loss_distribution \tab character \tab normal \tab normal, logistic, extreme \tab - \cr
   aft_loss_distribution_scale \tab numeric \tab - \tab  \tab \eqn{(-\infty, \infty)}{(-Inf, Inf)} \cr
   alpha \tab numeric \tab 0 \tab  \tab \eqn{[0, \infty)}{[0, Inf)} \cr
   base_score \tab numeric \tab 0.5 \tab  \tab \eqn{(-\infty, \infty)}{(-Inf, Inf)} \cr
   booster \tab character \tab gbtree \tab gbtree, gblinear, dart \tab - \cr
   callbacks \tab list \tab NULL \tab  \tab - \cr
   colsample_bylevel \tab numeric \tab 1 \tab  \tab \eqn{[0, 1]}{[0, 1]} \cr
   colsample_bynode \tab numeric \tab 1 \tab  \tab \eqn{[0, 1]}{[0, 1]} \cr
   colsample_bytree \tab numeric \tab 1 \tab  \tab \eqn{[0, 1]}{[0, 1]} \cr
   disable_default_eval_metric \tab logical \tab FALSE \tab TRUE, FALSE \tab - \cr
   early_stopping_rounds \tab integer \tab NULL \tab  \tab \eqn{[1, \infty)}{[1, Inf)} \cr
   eta \tab numeric \tab 0.3 \tab  \tab \eqn{[0, 1]}{[0, 1]} \cr
   feature_selector \tab character \tab cyclic \tab cyclic, shuffle, random, greedy, thrifty \tab - \cr
   feval \tab list \tab NULL \tab  \tab - \cr
   gamma \tab numeric \tab 0 \tab  \tab \eqn{[0, \infty)}{[0, Inf)} \cr
   grow_policy \tab character \tab depthwise \tab depthwise, lossguide \tab - \cr
   interaction_constraints \tab list \tab - \tab  \tab - \cr
   iterationrange \tab list \tab - \tab  \tab - \cr
   lambda \tab numeric \tab 1 \tab  \tab \eqn{[0, \infty)}{[0, Inf)} \cr
   lambda_bias \tab numeric \tab 0 \tab  \tab \eqn{[0, \infty)}{[0, Inf)} \cr
   max_bin \tab integer \tab 256 \tab  \tab \eqn{[2, \infty)}{[2, Inf)} \cr
   max_delta_step \tab numeric \tab 0 \tab  \tab \eqn{[0, \infty)}{[0, Inf)} \cr
   max_depth \tab integer \tab 6 \tab  \tab \eqn{[0, \infty)}{[0, Inf)} \cr
   max_leaves \tab integer \tab 0 \tab  \tab \eqn{[0, \infty)}{[0, Inf)} \cr
   maximize \tab logical \tab NULL \tab TRUE, FALSE \tab - \cr
   min_child_weight \tab numeric \tab 1 \tab  \tab \eqn{[0, \infty)}{[0, Inf)} \cr
   missing \tab numeric \tab NA \tab  \tab \eqn{(-\infty, \infty)}{(-Inf, Inf)} \cr
   monotone_constraints \tab integer \tab 0 \tab  \tab \eqn{[-1, 1]}{[-1, 1]} \cr
   normalize_type \tab character \tab tree \tab tree, forest \tab - \cr
   nrounds \tab integer \tab - \tab  \tab \eqn{[1, \infty)}{[1, Inf)} \cr
   nthread \tab integer \tab 1 \tab  \tab \eqn{[1, \infty)}{[1, Inf)} \cr
   ntreelimit \tab integer \tab - \tab  \tab \eqn{[1, \infty)}{[1, Inf)} \cr
   num_parallel_tree \tab integer \tab 1 \tab  \tab \eqn{[1, \infty)}{[1, Inf)} \cr
   objective \tab character \tab survival:cox \tab survival:cox, survival:aft \tab - \cr
   one_drop \tab logical \tab FALSE \tab TRUE, FALSE \tab - \cr
   predictor \tab character \tab cpu_predictor \tab cpu_predictor, gpu_predictor \tab - \cr
   print_every_n \tab integer \tab 1 \tab  \tab \eqn{[1, \infty)}{[1, Inf)} \cr
   process_type \tab character \tab default \tab default, update \tab - \cr
   rate_drop \tab numeric \tab 0 \tab  \tab \eqn{[0, 1]}{[0, 1]} \cr
   refresh_leaf \tab logical \tab TRUE \tab TRUE, FALSE \tab - \cr
   sampling_method \tab character \tab uniform \tab uniform, gradient_based \tab - \cr
   sample_type \tab character \tab uniform \tab uniform, weighted \tab - \cr
   save_name \tab list \tab - \tab  \tab - \cr
   save_period \tab integer \tab - \tab  \tab \eqn{[0, \infty)}{[0, Inf)} \cr
   scale_pos_weight \tab numeric \tab 1 \tab  \tab \eqn{(-\infty, \infty)}{(-Inf, Inf)} \cr
   seed_per_iteration \tab logical \tab FALSE \tab TRUE, FALSE \tab - \cr
   sketch_eps \tab numeric \tab 0.03 \tab  \tab \eqn{[0, 1]}{[0, 1]} \cr
   skip_drop \tab numeric \tab 0 \tab  \tab \eqn{[0, 1]}{[0, 1]} \cr
   single_precision_histogram \tab logical \tab FALSE \tab TRUE, FALSE \tab - \cr
   strict_shape \tab logical \tab FALSE \tab TRUE, FALSE \tab - \cr
   subsample \tab numeric \tab 1 \tab  \tab \eqn{[0, 1]}{[0, 1]} \cr
   top_k \tab integer \tab 0 \tab  \tab \eqn{[0, \infty)}{[0, Inf)} \cr
   tree_method \tab character \tab auto \tab auto, exact, approx, hist, gpu_hist \tab - \cr
   tweedie_variance_power \tab numeric \tab 1.5 \tab  \tab \eqn{[1, 2]}{[1, 2]} \cr
   updater \tab list \tab - \tab  \tab - \cr
   verbose \tab integer \tab 1 \tab  \tab \eqn{[0, 2]}{[0, 2]} \cr
   watchlist \tab list \tab NULL \tab  \tab - \cr
   xgb_model \tab list \tab - \tab  \tab - \cr
}
}

\examples{
if (requireNamespace("xgboost", quietly = TRUE)) {
  learner = mlr3::lrn("surv.xgboost")
  print(learner)

  # available parameters:
learner$param_set$ids()
}
}
\references{
Chen, Tianqi, Guestrin, Carlos (2016).
\dQuote{Xgboost: A scalable tree boosting system.}
In \emph{Proceedings of the 22nd ACM SIGKDD Conference on Knowledge Discovery and Data Mining}, 785--794.
ACM.
\doi{10.1145/2939672.2939785}.
}
\seealso{
\itemize{
\item Chapter in the \href{https://mlr3book.mlr-org.com/}{mlr3book}:
\url{https://mlr3book.mlr-org.com/basics.html#learners}
\item Package \href{https://github.com/mlr-org/mlr3extralearners}{mlr3extralearners} for more learners.
\item \link[mlr3misc:Dictionary]{Dictionary} of \link[=Learner]{Learners}: \link{mlr_learners}
\item \code{as.data.table(mlr_learners)} for a table of available \link[=Learner]{Learners} in the running session (depending on the loaded packages).
\item \CRANpkg{mlr3pipelines} to combine learners with pre- and postprocessing steps.
\item Extension packages for additional task types:
\itemize{
\item \CRANpkg{mlr3proba} for probabilistic supervised regression and survival analysis.
\item \CRANpkg{mlr3cluster} for unsupervised clustering.
}
\item \CRANpkg{mlr3tuning} for tuning of hyperparameters, \CRANpkg{mlr3tuningspaces}
for established default tuning spaces.
}

Other Learner: 
\code{\link{mlr_learners_classif.cv_glmnet}},
\code{\link{mlr_learners_classif.glmnet}},
\code{\link{mlr_learners_classif.kknn}},
\code{\link{mlr_learners_classif.lda}},
\code{\link{mlr_learners_classif.log_reg}},
\code{\link{mlr_learners_classif.multinom}},
\code{\link{mlr_learners_classif.naive_bayes}},
\code{\link{mlr_learners_classif.nnet}},
\code{\link{mlr_learners_classif.qda}},
\code{\link{mlr_learners_classif.ranger}},
\code{\link{mlr_learners_classif.svm}},
\code{\link{mlr_learners_classif.xgboost}},
\code{\link{mlr_learners_regr.cv_glmnet}},
\code{\link{mlr_learners_regr.glmnet}},
\code{\link{mlr_learners_regr.kknn}},
\code{\link{mlr_learners_regr.km}},
\code{\link{mlr_learners_regr.lm}},
\code{\link{mlr_learners_regr.ranger}},
\code{\link{mlr_learners_regr.svm}},
\code{\link{mlr_learners_regr.xgboost}},
\code{\link{mlr_learners_surv.cv_glmnet}},
\code{\link{mlr_learners_surv.glmnet}},
\code{\link{mlr_learners_surv.ranger}}
}
\concept{Learner}
\section{Super classes}{
\code{\link[mlr3:Learner]{mlr3::Learner}} -> \code{\link[mlr3proba:LearnerSurv]{mlr3proba::LearnerSurv}} -> \code{LearnerSurvXgboost}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{LearnerSurvXgboost$new()}}
\item \href{#method-importance}{\code{LearnerSurvXgboost$importance()}}
\item \href{#method-clone}{\code{LearnerSurvXgboost$clone()}}
}
}
\if{html}{
\out{<details ><summary>Inherited methods</summary>}
\itemize{
\item \out{<span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="base_learner">}\href{../../mlr3/html/Learner.html#method-base_learner}{\code{mlr3::Learner$base_learner()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="format">}\href{../../mlr3/html/Learner.html#method-format}{\code{mlr3::Learner$format()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="help">}\href{../../mlr3/html/Learner.html#method-help}{\code{mlr3::Learner$help()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="predict">}\href{../../mlr3/html/Learner.html#method-predict}{\code{mlr3::Learner$predict()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="predict_newdata">}\href{../../mlr3/html/Learner.html#method-predict_newdata}{\code{mlr3::Learner$predict_newdata()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="print">}\href{../../mlr3/html/Learner.html#method-print}{\code{mlr3::Learner$print()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="reset">}\href{../../mlr3/html/Learner.html#method-reset}{\code{mlr3::Learner$reset()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="train">}\href{../../mlr3/html/Learner.html#method-train}{\code{mlr3::Learner$train()}}\out{</span>}
}
\out{</details>}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Creates a new instance of this \link[R6:R6Class]{R6} class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LearnerSurvXgboost$new()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-importance"></a>}}
\if{latex}{\out{\hypertarget{method-importance}{}}}
\subsection{Method \code{importance()}}{
The importance scores are calculated with \code{\link[xgboost:xgb.importance]{xgboost::xgb.importance()}}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LearnerSurvXgboost$importance()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Named \code{numeric()}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LearnerSurvXgboost$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
